"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createTableVisFn = void 0;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/visualizations-plugin/public");
var _common = require("../common");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createTableVisFn = () => ({
  name: 'kibana_table',
  type: 'render',
  inputTypes: ['datatable'],
  help: _i18n.i18n.translate('visTypeTable.function.help', {
    defaultMessage: 'Table visualization'
  }),
  args: {
    metrics: {
      types: ['vis_dimension'],
      help: _i18n.i18n.translate('visTypeTable.function.args.metricsHelpText', {
        defaultMessage: 'Metrics dimensions config'
      }),
      required: true,
      multi: true
    },
    buckets: {
      types: ['vis_dimension'],
      help: _i18n.i18n.translate('visTypeTable.function.args.bucketsHelpText', {
        defaultMessage: 'Buckets dimensions config'
      }),
      multi: true
    },
    splitColumn: {
      types: ['vis_dimension'],
      help: _i18n.i18n.translate('visTypeTable.function.args.splitColumnHelpText', {
        defaultMessage: 'Split by column dimension config'
      })
    },
    splitRow: {
      types: ['vis_dimension'],
      help: _i18n.i18n.translate('visTypeTable.function.args.splitRowHelpText', {
        defaultMessage: 'Split by row dimension config'
      })
    },
    percentageCol: {
      types: ['string'],
      help: _i18n.i18n.translate('visTypeTable.function.args.percentageColHelpText', {
        defaultMessage: 'Name of column to show percentage for'
      }),
      default: ''
    },
    perPage: {
      types: ['number'],
      default: '',
      help: _i18n.i18n.translate('visTypeTable.function.args.perPageHelpText', {
        defaultMessage: 'The number of rows at a table page is used for pagination'
      })
    },
    row: {
      types: ['boolean'],
      help: _i18n.i18n.translate('visTypeTable.function.args.rowHelpText', {
        defaultMessage: 'Row value is used for split table mode. Set to "true" to split by row'
      })
    },
    showPartialRows: {
      types: ['boolean'],
      help: '',
      default: false
    },
    showMetricsAtAllLevels: {
      types: ['boolean'],
      help: '',
      default: false
    },
    showToolbar: {
      types: ['boolean'],
      help: _i18n.i18n.translate('visTypeTable.function.args.showToolbarHelpText', {
        defaultMessage: `Set to "true" to show grid's toolbar with "Export" button`
      }),
      default: false
    },
    showTotal: {
      types: ['boolean'],
      help: _i18n.i18n.translate('visTypeTable.function.args.showTotalHelpText', {
        defaultMessage: 'Set to "true" to show the total row'
      }),
      default: false
    },
    title: {
      types: ['string'],
      help: _i18n.i18n.translate('visTypeTable.function.args.titleHelpText', {
        defaultMessage: 'The visualization title. The title is used for CSV export as a default file name'
      })
    },
    totalFunc: {
      types: ['string'],
      help: _i18n.i18n.translate('visTypeTable.function.args.totalFuncHelpText', {
        defaultMessage: 'Specifies calculating function for the total row. Possible options are: '
      })
    },
    autoFitRowToContent: {
      types: ['boolean'],
      help: '',
      default: false
    }
  },
  fn(input, args, handlers) {
    var _convertedData$table$, _convertedData$table, _convertedData$table$2, _convertedData$table2, _handlers$inspectorAd, _ref;
    const convertedData = (0, _utils.tableVisResponseHandler)(input, args);
    const inspectorData = {
      rows: (_convertedData$table$ = convertedData === null || convertedData === void 0 ? void 0 : (_convertedData$table = convertedData.table) === null || _convertedData$table === void 0 ? void 0 : _convertedData$table.rows) !== null && _convertedData$table$ !== void 0 ? _convertedData$table$ : input.rows,
      columns: (_convertedData$table$2 = convertedData === null || convertedData === void 0 ? void 0 : (_convertedData$table2 = convertedData.table) === null || _convertedData$table2 === void 0 ? void 0 : _convertedData$table2.columns) !== null && _convertedData$table$2 !== void 0 ? _convertedData$table$2 : input.columns,
      type: 'datatable'
    };
    if (handlers !== null && handlers !== void 0 && (_handlers$inspectorAd = handlers.inspectorAdapters) !== null && _handlers$inspectorAd !== void 0 && _handlers$inspectorAd.tables) {
      const argsTable = [[args.metrics, _i18n.i18n.translate('visTypeTable.function.dimension.metrics', {
        defaultMessage: 'Metrics'
      })], [args.buckets, _i18n.i18n.translate('visTypeTable.function.adimension.buckets', {
        defaultMessage: 'Buckets'
      })]];
      if (args.splitColumn) {
        argsTable.push([[args.splitColumn], _i18n.i18n.translate('visTypeTable.function.dimension.splitColumn', {
          defaultMessage: 'Split by column'
        })]);
      }
      if (args.splitRow) {
        argsTable.push([[args.splitRow], _i18n.i18n.translate('visTypeTable.function.dimension.splitRow', {
          defaultMessage: 'Split by row'
        })]);
      }
      const logTable = (0, _public.prepareLogTable)(inspectorData, argsTable);
      handlers.inspectorAdapters.tables.logDatatable('default', logTable);
    }
    return {
      type: 'render',
      as: 'table_vis',
      value: {
        visData: convertedData,
        visType: _common.VIS_TYPE_TABLE,
        visConfig: {
          ...args,
          title: (_ref = handlers.variables.embeddableTitle) !== null && _ref !== void 0 ? _ref : args.title
        },
        canNavigateToLens: handlers.variables.canNavigateToLens
      }
    };
  }
});
exports.createTableVisFn = createTableVisFn;