"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = SettingsOptions;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/vis-default-editor-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function SettingsOptions({
  stateParams,
  setValue
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_public.RangeOption, {
    label: _i18n.i18n.translate('visTypeMarkdown.params.fontSizeLabel', {
      defaultMessage: 'Base font size in points'
    }),
    max: 36,
    min: 8,
    paramName: "fontSize",
    showInput: true,
    value: stateParams.fontSize,
    setValue: setValue
  }), /*#__PURE__*/_react.default.createElement(_public.SwitchOption, {
    label: _i18n.i18n.translate('visTypeMarkdown.params.openLinksLabel', {
      defaultMessage: 'Open links in new tab'
    }),
    paramName: "openLinksInNewTab",
    value: stateParams.openLinksInNewTab,
    setValue: setValue
  }));
}

// default export required for React.Lazy
// eslint-disable-next-line import/no-default-export
module.exports = exports.default;