"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useOptionTabs = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _data_tab = require("./data_tab");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const useOptionTabs = ({
  type: visType
}) => {
  const [optionTabs, setOptionTabs] = (0, _react.useState)(() => {
    var _visType$schemas$buck, _visType$schemas$metr;
    const tabs = [...((_visType$schemas$buck = visType.schemas.buckets) !== null && _visType$schemas$buck !== void 0 && _visType$schemas$buck.length || (_visType$schemas$metr = visType.schemas.metrics) !== null && _visType$schemas$metr !== void 0 && _visType$schemas$metr.length ? [{
      name: 'data',
      title: _i18n.i18n.translate('visDefaultEditor.sidebar.tabs.dataLabel', {
        defaultMessage: 'Data'
      }),
      editor: _data_tab.DefaultEditorDataTab
    }] : []), ...(!visType.editorConfig.optionTabs && visType.editorConfig.optionsTemplate ? [{
      name: 'options',
      title: _i18n.i18n.translate('visDefaultEditor.sidebar.tabs.optionsLabel', {
        defaultMessage: 'Options'
      }),
      editor: visType.editorConfig.optionsTemplate
    }] : visType.editorConfig.optionTabs)];
    // set up the first tab as selected
    tabs[0].isSelected = true;
    return tabs;
  });
  const setSelectedTab = (0, _react.useCallback)(name => {
    setOptionTabs(tabs => tabs.map(tab => ({
      ...tab,
      isSelected: tab.name === name
    })));
  }, []);
  return [optionTabs, setSelectedTab];
};
exports.useOptionTabs = useOptionTabs;