"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MappingErrorPage = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _use_breadcrumbs = require("../hooks/use_breadcrumbs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MappingErrorPage = () => {
  (0, _public2.useTrackPageview)({
    app: 'uptime',
    path: 'mapping-error'
  });
  (0, _public2.useTrackPageview)({
    app: 'uptime',
    path: 'mapping-error',
    delay: 15000
  });
  const docLinks = (0, _public.useKibana)().services.docLinks;
  (0, _use_breadcrumbs.useBreadcrumbs)([{
    text: _i18n.i18n.translate('xpack.uptime.mappingErrorRoute.breadcrumb', {
      defaultMessage: 'Mapping error'
    })
  }]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": "xpack.synthetics.mappingsErrorPage",
    iconColor: "danger",
    iconType: "cross",
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.uptime.public.pages.mappingError.title",
      defaultMessage: "Heartbeat mappings missing"
    }))),
    body: /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.uptime.public.pages.mappingError.bodyMessage",
      defaultMessage: "Incorrect mappings detected! Perhaps you forgot to run the heartbeat {setup} command?",
      values: {
        setup: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "setup")
      }
    })), docLinks && /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.uptime.public.pages.mappingError.bodyDocsLink",
      defaultMessage: "You can learn how to troubleshoot this issue in the {docsLink}.",
      values: {
        docsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "syntheticsMappingErrorPageDocsLink",
          href: `${docLinks.ELASTIC_WEBSITE_URL}guide/en/observability/${docLinks.DOC_LINK_VERSION}/troubleshoot-uptime-mapping-issues.html`,
          target: "_blank"
        }, "docs")
      }
    })))
  });
};
exports.MappingErrorPage = MappingErrorPage;