"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGenerateUpdatedKueryString = void 0;
var _esQuery = require("@kbn/es-query");
var _react = require("react");
var _uptime_refresh_context = require("../contexts/uptime_refresh_context");
var _uptime_data_view_context = require("../contexts/uptime_data_view_context");
var _filter_group = require("../components/overview/filter_group/filter_group");
var _lib = require("../../../common/lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getKueryString = (urlFilters, excludedFilters, logicalANDForTag) => {
  let kueryString = '';
  let excludeKueryString = '';
  // We are using try/catch here because this is user entered value
  // and JSON.parse and stringifyKueries can have hard time parsing
  // all possible scenarios, we can safely ignore if we can't parse them
  try {
    if (urlFilters !== '') {
      const filterMap = new Map(JSON.parse(urlFilters));
      kueryString = (0, _lib.stringifyKueries)(filterMap, logicalANDForTag);
    }
  } catch {
    kueryString = '';
  }
  try {
    if (excludedFilters) {
      const filterMap = new Map(JSON.parse(excludedFilters));
      excludeKueryString = (0, _lib.stringifyKueries)(filterMap, logicalANDForTag);
      if (kueryString) {
        return `${kueryString} and NOT (${excludeKueryString})`;
      }
    } else {
      return kueryString;
    }
  } catch {
    excludeKueryString = '';
  }
  return `NOT (${excludeKueryString})`;
};
const useGenerateUpdatedKueryString = (filterQueryString = '', urlFilters, excludedFilters, disableANDFiltering) => {
  const dataView = (0, _uptime_data_view_context.useUptimeDataView)();
  const {
    lastRefresh
  } = (0, _uptime_refresh_context.useUptimeRefreshContext)();
  const [kueryString, setKueryString] = (0, _react.useState)('');
  (0, _react.useEffect)(() => {
    if (disableANDFiltering) {
      setKueryString(getKueryString(urlFilters, excludedFilters));
    } else {
      // need a string comparison for local storage
      const useLogicalAND = localStorage.getItem(_filter_group.TAG_KEY_FOR_AND_CONDITION) === 'true';
      setKueryString(getKueryString(urlFilters, excludedFilters, useLogicalAND));
    }
  }, [excludedFilters, urlFilters, lastRefresh, disableANDFiltering]);
  const combinedFilterString = (0, _lib.combineFiltersAndUserSearch)(filterQueryString, kueryString);
  let esFilters;
  // this try catch is necessary to evaluate user input in kuery bar,
  // this error will be actually shown in UI for user to see
  try {
    if ((filterQueryString || urlFilters || excludedFilters) && dataView && combinedFilterString) {
      const ast = (0, _esQuery.fromKueryExpression)(combinedFilterString);
      const elasticsearchQuery = (0, _esQuery.toElasticsearchQuery)(ast, dataView);
      esFilters = JSON.stringify(elasticsearchQuery);
    }
    return [esFilters];
  } catch (err) {
    return [urlFilters, err];
  }
};
exports.useGenerateUpdatedKueryString = useGenerateUpdatedKueryString;