"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorCharts = exports.MONITOR_CHART_HEIGHT = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _ping_histogram_container = require("./ping_histogram/ping_histogram_container");
var _monitor_duration_container = require("./monitor_duration/monitor_duration_container");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MONITOR_CHART_HEIGHT = exports.MONITOR_CHART_HEIGHT = '248px';
const MonitorCharts = ({
  monitorId
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_monitor_duration_container.MonitorDuration, {
    monitorId: monitorId
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_ping_histogram_container.PingHistogram, {
    height: MONITOR_CHART_HEIGHT,
    isResponsive: false
  })));
};
exports.MonitorCharts = MonitorCharts;