"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UptimeEditAlertFlyoutComponent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _flyout = require("@kbn/response-ops-rule-form/flyout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UptimeEditAlertFlyoutComponent = ({
  alertFlyoutVisible,
  initialAlert,
  setAlertFlyoutVisibility
}) => {
  const {
    triggersActionsUi,
    ...plugins
  } = (0, _public.useKibana)().services;
  const onClose = (0, _react.useCallback)(() => {
    setAlertFlyoutVisibility(false);
  }, [setAlertFlyoutVisibility]);
  const EditAlertFlyout = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_flyout.RuleFormFlyout, {
    id: initialAlert.id,
    onCancel: onClose,
    onSubmit: onClose,
    plugins: {
      ...plugins,
      ruleTypeRegistry: triggersActionsUi.ruleTypeRegistry,
      actionTypeRegistry: triggersActionsUi.actionTypeRegistry
    }
  }), [initialAlert, triggersActionsUi, onClose, plugins]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, alertFlyoutVisible && EditAlertFlyout);
};
exports.UptimeEditAlertFlyoutComponent = UptimeEditAlertFlyoutComponent;