"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReindexActionCell = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _types = require("../../../../../../common/types");
var _context = require("./context");
var _types2 = require("../../../types");
var _action_buttons = require("../../common/action_buttons");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const actionsI18nTexts = {
  reindexLoadingActionsText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indices.reindexLoadingActionsText', {
    defaultMessage: 'Loading actions…'
  }),
  reindexTooltipLabel: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indices.reindexTooltipLabel', {
    defaultMessage: 'Resolve this issue by reindexing into a new, compatible index.'
  }),
  readOnlyTooltipLabel: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indices.readOnlyTooltipLabel', {
    defaultMessage: 'Resolve this issue by setting this index to read-only.'
  }),
  unfreezeTooltipLabel: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indices.unfreezeTooltipLabel', {
    defaultMessage: 'Resolve this issue by unfreezing this index.'
  }),
  deleteTooltipLabel: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indices.deleteTooltipLabel', {
    defaultMessage: 'Resolve this issue by deleting this index.'
  })
};
const UnfreezeActionButtons = ({
  openFlyout,
  correctiveAction,
  setSelectedResolutionType,
  openModal,
  deprecation
}) => {
  const {
    reindexState,
    updateIndexState: {
      status,
      updateAction
    }
  } = (0, _context.useIndexContext)();
  const reindexingInProgressOrCompleted = reindexState.status === _types.ReindexStatus.inProgress || reindexState.status === _types.ReindexStatus.completed;
  const updateInProgressOrCompleted = status === 'complete' || status === 'inProgress';
  const isUnfreezing = updateAction === 'unfreeze' && updateInProgressOrCompleted;
  const isDeleting = updateAction === 'delete' && updateInProgressOrCompleted;
  const canDisplayUnfreeze = !!(reindexState.hasRequiredPrivileges && !reindexingInProgressOrCompleted && !isDeleting);
  const canDisplayReindex = !!(reindexState.hasRequiredPrivileges && !updateInProgressOrCompleted);
  const canDisplayDelete = !!(reindexState.hasRequiredPrivileges && !reindexingInProgressOrCompleted && !isUnfreezing && deprecation.level === 'critical');
  const actions = [{
    tooltip: actionsI18nTexts.reindexTooltipLabel,
    iconType: 'indexSettings',
    canDisplay: canDisplayReindex,
    resolutionType: 'reindex',
    onClick: () => {
      openFlyout();
    }
  }, {
    tooltip: actionsI18nTexts.unfreezeTooltipLabel,
    iconType: 'readOnly',
    canDisplay: canDisplayUnfreeze,
    resolutionType: 'unfreeze',
    onClick: () => {
      openModal();
      setSelectedResolutionType('unfreeze');
    }
  }, {
    tooltip: actionsI18nTexts.deleteTooltipLabel,
    iconType: 'trash',
    canDisplay: canDisplayDelete,
    resolutionType: 'delete',
    onClick: () => {
      openModal();
      setSelectedResolutionType('delete');
    }
  }];
  return /*#__PURE__*/_react.default.createElement(_action_buttons.ActionButtons, {
    actions: actions,
    dataTestSubjPrefix: correctiveAction.type
  });
};
const ReindexActionButtons = ({
  openFlyout,
  correctiveAction,
  setSelectedResolutionType,
  openModal,
  deprecation
}) => {
  const {
    excludedActions = []
  } = correctiveAction;
  const {
    reindexState,
    updateIndexState: {
      status,
      updateAction
    }
  } = (0, _context.useIndexContext)();
  const {
    meta
  } = reindexState;
  const {
    isReadonly,
    isFollowerIndex
  } = meta;
  const reindexingInProgressOrCompleted = reindexState.status === _types.ReindexStatus.inProgress || reindexState.status === _types.ReindexStatus.completed;
  const updateInProgressOrCompleted = status === 'complete' || status === 'inProgress';
  const isSettingReadOnly = updateAction === 'readonly' && updateInProgressOrCompleted;
  const isDeleting = updateAction === 'delete' && updateInProgressOrCompleted;
  const readOnlyExcluded = excludedActions.includes('readOnly');
  const reindexExcluded = excludedActions.includes('reindex');
  const canDisplayReadOnly = !!(reindexState.hasRequiredPrivileges && !readOnlyExcluded && !isReadonly && !reindexingInProgressOrCompleted && !isDeleting);
  const canDisplayReindex = !!(reindexState.hasRequiredPrivileges && !reindexExcluded && !isFollowerIndex && !updateInProgressOrCompleted);
  const canDisplayDelete = !!(reindexState.hasRequiredPrivileges && !reindexingInProgressOrCompleted && !isSettingReadOnly && deprecation.level === 'critical');
  const actions = [{
    tooltip: actionsI18nTexts.reindexTooltipLabel,
    iconType: 'indexSettings',
    canDisplay: canDisplayReindex,
    resolutionType: 'reindex',
    onClick: () => {
      openFlyout();
    }
  }, {
    tooltip: actionsI18nTexts.readOnlyTooltipLabel,
    iconType: 'readOnly',
    canDisplay: canDisplayReadOnly,
    resolutionType: 'readonly',
    onClick: () => {
      openModal();
      setSelectedResolutionType('readonly');
    }
  }, {
    tooltip: actionsI18nTexts.deleteTooltipLabel,
    iconType: 'trash',
    canDisplay: canDisplayDelete,
    resolutionType: 'delete',
    onClick: () => {
      openModal();
      setSelectedResolutionType('delete');
    }
  }];
  return /*#__PURE__*/_react.default.createElement(_action_buttons.ActionButtons, {
    actions: actions,
    dataTestSubjPrefix: correctiveAction.type
  });
};
const ReindexActionCell = ({
  openFlyout,
  setSelectedResolutionType,
  openModal
}) => {
  var _deprecation$correcti;
  const {
    reindexState,
    deprecation
  } = (0, _context.useIndexContext)();
  const correctiveAction = (_deprecation$correcti = deprecation.correctiveAction) === null || _deprecation$correcti === void 0 ? void 0 : _deprecation$correcti.type;
  if (reindexState.loadingState === _types2.LoadingState.Loading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, actionsI18nTexts.reindexLoadingActionsText)));
  }
  return correctiveAction === 'unfreeze' ? /*#__PURE__*/_react.default.createElement(UnfreezeActionButtons, {
    openFlyout: openFlyout,
    correctiveAction: deprecation.correctiveAction,
    setSelectedResolutionType: setSelectedResolutionType,
    openModal: openModal,
    deprecation: deprecation
  }) : /*#__PURE__*/_react.default.createElement(ReindexActionButtons, {
    openFlyout: openFlyout,
    correctiveAction: deprecation.correctiveAction,
    setSelectedResolutionType: setSelectedResolutionType,
    openModal: openModal,
    deprecation: deprecation
  });
};
exports.ReindexActionCell = ReindexActionCell;