"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterItem = FilterItem;
exports.strings = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _esQuery = require("@kbn/es-query");
var _css = require("@emotion/css");
var _react2 = require("@emotion/react");
var _field_input = require("./field_input");
var _operator_input = require("./operator_input");
var _params_editor = require("./params_editor");
var _utils = require("../../utils");
var _context = require("../context");
var _filter_group = require("../filter_group");
var _filter_editor = require("../../filter_bar/filter_editor");
var _filters_builder = require("../utils/filters_builder");
var _filter_item = require("./filter_item.styles");
var _tooltip = require("./tooltip");
var _actions = require("./actions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const strings = exports.strings = {
  getDragFilterAriaLabel: () => _i18n.i18n.translate('unifiedSearch.filter.filtersBuilder.dragFilterAriaLabel', {
    defaultMessage: 'Drag filter'
  }),
  getReorderingRequirementsLabel: () => _i18n.i18n.translate('unifiedSearch.filter.filtersBuilder.dragHandleDisabled', {
    defaultMessage: 'Reordering requires more than one item.'
  })
};
const MAX_FILTER_NESTING = 5;
const isMaxFilterNesting = path => {
  const pathArr = path.split('.');
  return pathArr.length - 1 === MAX_FILTER_NESTING;
};
function FilterItem({
  filter,
  path,
  reverseBackground,
  disableOr,
  disableAnd,
  disableRemove,
  color,
  index,
  renderedLevel,
  draggable = true,
  filtersCount = 1
}) {
  const {
    dispatch,
    dataView,
    dropTarget,
    globalParams: {
      hideOr
    },
    timeRangeForSuggestionsOverride,
    filtersForSuggestions,
    disabled
  } = (0, _react.useContext)(_context.FiltersBuilderContextType);
  const conditionalOperationType = (0, _utils.getBooleanRelationType)(filter);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  let field;
  let params;
  const isMaxNesting = isMaxFilterNesting(path);
  if (!conditionalOperationType) {
    field = (0, _filter_editor.getFieldFromFilter)(filter, dataView);
    if (field) {
      params = (0, _esQuery.getFilterParams)(filter);
    }
  }
  const [operator, setOperator] = (0, _react.useState)(() => {
    if (!conditionalOperationType && field) {
      return (0, _filter_editor.getOperatorFromFilter)(filter);
    }
  });
  const [multiValueFilterParams, setMultiValueFilterParams] = (0, _react.useState)(Array.isArray(params) ? params : []);
  const onHandleField = (0, _react.useCallback)(selectedField => {
    setOperator(undefined);
    dispatch({
      type: 'updateFilter',
      payload: {
        dest: {
          path,
          index
        },
        field: selectedField
      }
    });
  }, [dispatch, path, index]);
  const onHandleOperator = (0, _react.useCallback)(selectedOperator => {
    var _selectedOperator$get, _selectedOperator$get2;
    const preservedParams = params && ((_selectedOperator$get = selectedOperator.getParamsFromPrevOperator) === null || _selectedOperator$get === void 0 ? void 0 : _selectedOperator$get.call(selectedOperator, operator, params));
    setMultiValueFilterParams(Array.isArray(preservedParams) ? preservedParams : []);
    setOperator(selectedOperator);
    dispatch({
      type: 'updateFilter',
      payload: {
        dest: {
          path,
          index
        },
        field,
        operator: selectedOperator,
        params: params && ((_selectedOperator$get2 = selectedOperator.getParamsFromPrevOperator) === null || _selectedOperator$get2 === void 0 ? void 0 : _selectedOperator$get2.call(selectedOperator, operator, params))
      }
    });
  }, [dispatch, path, index, field, operator, params]);
  const onHandleParamsChange = (0, _react.useCallback)(selectedParams => {
    if (Array.isArray(selectedParams)) {
      setMultiValueFilterParams(selectedParams);
    }
    dispatch({
      type: 'updateFilter',
      payload: {
        dest: {
          path,
          index
        },
        field,
        operator,
        params: selectedParams
      }
    });
  }, [dispatch, path, index, field, operator]);
  const onHandleParamsUpdate = (0, _react.useCallback)(value => {
    const paramsValues = Array.isArray(multiValueFilterParams) ? multiValueFilterParams : [];
    if (value) {
      paramsValues.push(value);
      setMultiValueFilterParams(paramsValues);
    }
    dispatch({
      type: 'updateFilter',
      payload: {
        dest: {
          path,
          index
        },
        field,
        operator,
        params: paramsValues
      }
    });
  }, [dispatch, path, index, field, operator, multiValueFilterParams]);
  const onRemoveFilter = (0, _react.useCallback)(() => {
    dispatch({
      type: 'removeFilter',
      payload: {
        dest: {
          path,
          index
        }
      }
    });
  }, [dispatch, path, index]);
  const onAddFilter = (0, _react.useCallback)(booleanRelation => {
    dispatch({
      type: 'addFilter',
      payload: {
        dest: {
          path,
          index: index + 1
        },
        filter: (0, _esQuery.buildEmptyFilter)(false, dataView === null || dataView === void 0 ? void 0 : dataView.id),
        booleanRelation,
        dataView
      }
    });
  }, [dispatch, dataView, path, index]);
  const onAddButtonClick = (0, _react.useCallback)(() => onAddFilter(_esQuery.BooleanRelation.AND), [onAddFilter]);
  const onOrButtonClick = (0, _react.useCallback)(() => onAddFilter(_esQuery.BooleanRelation.OR), [onAddFilter]);
  const isMobile = (0, _eui.useIsWithinBreakpoints)(['xs', 's']);
  const ActionsComponent = isMobile ? _actions.MinimisedFilterItemActions : _actions.FilterItemActions;
  return /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _css.cx)({
      'filter-builder__item': true,
      'filter-builder__item-nested': renderedLevel > 0
    })
  }, conditionalOperationType ? /*#__PURE__*/_react.default.createElement(_filter_group.FilterGroup, {
    path: path,
    booleanRelation: conditionalOperationType,
    filters: (0, _filters_builder.getGroupedFilters)(filter),
    reverseBackground: !reverseBackground,
    renderedLevel: renderedLevel + 1
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiDroppable, {
    droppableId: path,
    spacing: "none",
    isCombineEnabled: !disableOr || !hideOr,
    className: (0, _css.cx)({
      [_filter_item.cursorAddCss]: dropTarget === path
    }),
    isDropDisabled: disableAnd
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDraggable, {
    spacing: "s",
    index: index,
    isDragDisabled: !draggable,
    draggableId: `${path}`,
    customDragHandle: true,
    hasInteractiveChildren: true,
    disableInteractiveElementBlocking: true,
    className: (0, _css.cx)(_filter_item.disabledDraggableCss),
    usePortal: true
  }, provided => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    responsive: false,
    alignItems: "center",
    justifyContent: "center",
    "data-test-subj": `filter-${path}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: color,
    paddingSize: 'none',
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    alignItems: "center",
    gutterSize: "s",
    justifyContent: "center",
    className: (0, _css.cx)({
      [_filter_item.cursorOrCss]: dropTarget === path && !hideOr
    }),
    css:
    // With a single filter there's a disabled cursor set at dragging level
    // so we need to revert such css directive for the rest of the editor row
    filtersCount === 1 ? (0, _react2.css)`
                              cursor: auto;
                            ` : undefined
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, (0, _extends2.default)({
    role: "button",
    grow: false,
    "aria-label": strings.getDragFilterAriaLabel()
  }, provided.dragHandleProps), /*#__PURE__*/_react.default.createElement(_tooltip.Tooltip, {
    content: strings.getReorderingRequirementsLabel(),
    show: !draggable
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, (0, _extends2.default)({
    type: "grab",
    size: "s",
    className: (0, _filter_item.getGrabIconCss)(euiTheme)
  }, !draggable ? {
    color: euiTheme.colors.disabled
  } : {})))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    alignItems: "center",
    justifyContent: "center",
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: (0, _filter_item.fieldAndParamCss)(euiTheme)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_field_input.FieldInput, {
    field: field,
    dataView: dataView,
    onHandleField: onHandleField
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: (0, _filter_item.operationCss)(euiTheme)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_operator_input.OperatorInput, {
    field: field,
    operator: operator,
    params: params,
    onHandleOperator: onHandleOperator
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: (0, _filter_item.fieldAndParamCss)(euiTheme)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "filterParams",
    css:
    // The disabled cursor downstream is unset
    // so force the correct cursor here based on the operator
    operator ? undefined : (0, _react2.css)`
                                        cursor: not-allowed;
                                      `
  }, /*#__PURE__*/_react.default.createElement(_params_editor.ParamsEditor, {
    dataView: dataView,
    field: field,
    operator: operator,
    params: params,
    onHandleParamsChange: onHandleParamsChange,
    onHandleParamsUpdate: onHandleParamsUpdate,
    timeRangeForSuggestionsOverride: timeRangeForSuggestionsOverride,
    filtersForSuggestions: filtersForSuggestions
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(ActionsComponent, {
    disabled: disabled,
    disableRemove: disableRemove,
    hideOr: hideOr || isMaxNesting,
    hideAnd: isMaxNesting,
    disableOr: disableOr,
    disableAnd: disableAnd,
    onRemoveFilter: onRemoveFilter,
    onOrButtonClick: onOrButtonClick,
    onAddButtonClick: onAddButtonClick
  })))))))));
}