"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Histogram = Histogram;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _use_time_range = require("./hooks/use_time_range");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function Histogram({
  services: {
    lens,
    uiSettings
  },
  dataView,
  chart: {
    timeInterval
  },
  bucketInterval,
  isPlainRecord,
  getTimeRange,
  requestData,
  lensProps,
  visContext,
  disableTriggers,
  disabledActions,
  onFilter,
  onBrushEnd,
  withDefaultActions,
  abortController
}) {
  const {
    timeRangeText,
    timeRangeDisplay
  } = (0, _use_time_range.useTimeRange)({
    uiSettings,
    bucketInterval,
    timeRange: getTimeRange(),
    timeInterval,
    isPlainRecord,
    timeField: dataView.timeFieldName
  });
  const {
    attributes
  } = visContext;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const boxShadow = `0 2px 2px -1px ${euiTheme.colors.mediumShade},
  0 1px 5px -2px ${euiTheme.colors.mediumShade}`;
  const chartCss = (0, _react.css)`
    position: relative;
    flex-grow: 1;
    margin-block: ${euiTheme.size.xs};

    & > div {
      height: 100%;
      position: absolute;
      width: 100%;
    }

    & .lnsExpressionRenderer {
      width: ${attributes.visualizationType === 'lnsMetric' ? '90%' : '100%'};
      margin: auto;
      box-shadow: ${attributes.visualizationType === 'lnsMetric' ? boxShadow : 'none'};
    }

    & .echLegend .echLegendList {
      padding-right: ${euiTheme.size.s};
    }

    & > .euiLoadingChart {
      position: absolute;
      top: 50%;
      left: 50%;
      transform: translate(-50%, -50%);
    }
  `;
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement("div", {
    "data-test-subj": "unifiedHistogramChart",
    "data-time-range": timeRangeText,
    "data-request-data": requestData,
    "data-suggestion-type": visContext.suggestionType,
    css: chartCss
  }, /*#__PURE__*/_react2.default.createElement(lens.EmbeddableComponent, (0, _extends2.default)({}, lensProps, {
    // forceDSL is set to true to ensure that the Lens always uses DSL to fetch the data
    // as some consumers (discover) rely on the total hits count which is not provided by ESQL
    forceDSL: true,
    abortController: abortController,
    disableTriggers: disableTriggers,
    disabledActions: disabledActions,
    onFilter: onFilter,
    onBrushEnd: onBrushEnd,
    withDefaultActions: withDefaultActions
  }))), timeRangeDisplay);
}