"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesListTable = void 0;
exports.convertRulesToTableItems = convertRulesToTableItems;
exports.percentileFields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _common = require("@kbn/alerting-plugin/common");
var _translations = require("../translations");
var _types = require("../../../../types");
var _constants = require("../../../constants");
var _execution_duration_utils = require("../../../lib/execution_duration_utils");
var _percentile_selectable_popover = require("./percentile_selectable_popover");
var _rule_duration_format = require("./rule_duration_format");
var _check_rule_type_enabled = require("../../../lib/check_rule_type_enabled");
var _monitoring_utils = require("../../../lib/monitoring_utils");
var _capabilities = require("../../../lib/capabilities");
var _rule_tag_badge = require("./rule_tag_badge");
var _rule_status_dropdown = require("./rule_status_dropdown");
var _notify_badge = require("./notify_badge");
var _rules_list_table_status_cell = require("./rules_list_table_status_cell");
var _get_experimental_features = require("../../../../common/get_experimental_features");
var _rules_list_column_selector = require("./rules_list_column_selector");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const percentileOrdinals = {
  [_types.Percentiles.P50]: '50th',
  [_types.Percentiles.P95]: '95th',
  [_types.Percentiles.P99]: '99th'
};
const percentileFields = exports.percentileFields = {
  [_types.Percentiles.P50]: 'monitoring.run.calculated_metrics.p50',
  [_types.Percentiles.P95]: 'monitoring.run.calculated_metrics.p95',
  [_types.Percentiles.P99]: 'monitoring.run.calculated_metrics.p99'
};
const EMPTY_OBJECT = {};
const EMPTY_HANDLER = () => {};
const EMPTY_RENDER = () => null;
function convertRulesToTableItems(opts) {
  const {
    rules,
    ruleTypeIndex,
    canExecuteActions,
    config
  } = opts;
  const minimumDuration = config.minimumScheduleInterval ? (0, _common.parseDuration)(config.minimumScheduleInterval.value) : 0;
  return rules.map((rule, index) => {
    var _ruleTypeIndex$get$na, _ruleTypeIndex$get, _ruleTypeIndex$get2, _ruleTypeIndex$get3;
    return {
      ...rule,
      index,
      actionsCount: rule.actions.length,
      ruleType: (_ruleTypeIndex$get$na = (_ruleTypeIndex$get = ruleTypeIndex.get(rule.ruleTypeId)) === null || _ruleTypeIndex$get === void 0 ? void 0 : _ruleTypeIndex$get.name) !== null && _ruleTypeIndex$get$na !== void 0 ? _ruleTypeIndex$get$na : rule.ruleTypeId,
      autoRecoverAlerts: (_ruleTypeIndex$get2 = ruleTypeIndex.get(rule.ruleTypeId)) === null || _ruleTypeIndex$get2 === void 0 ? void 0 : _ruleTypeIndex$get2.autoRecoverAlerts,
      isEditable: (0, _capabilities.hasAllPrivilege)(rule.consumer, ruleTypeIndex.get(rule.ruleTypeId)) && (canExecuteActions || !canExecuteActions && !rule.actions.length),
      enabledInLicense: !!((_ruleTypeIndex$get3 = ruleTypeIndex.get(rule.ruleTypeId)) !== null && _ruleTypeIndex$get3 !== void 0 && _ruleTypeIndex$get3.enabledInLicense),
      showIntervalWarning: (0, _common.parseDuration)(rule.schedule.interval) < minimumDuration
    };
  });
}
const ruleSidebarActionCss = (0, _react2.css)`
  opacity: 0; /* 1 */

  &.ruleSidebarItem__mobile {
    opacity: 1;
  }

  &:focus {
    opacity: 1; /* 2 */
  }
`;
const LAST_RUN_CONTENT = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.rulesListTable.columns.lastRunTitleTooltip', {
  defaultMessage: 'Start time of the last run.'
});
const SNOOZE_RULE_NOTIFICATIONS = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.rulesListTable.columns.notifyTooltip', {
  defaultMessage: 'Snooze notifications for a rule.'
});
const RulesListTable = props => {
  const {
    rulesListKey,
    rulesState,
    items = [],
    ruleTypesState,
    ruleTypeRegistry,
    isLoading = false,
    sort,
    isPageSelected = false,
    isAllSelected = false,
    numberOfSelectedRules = 0,
    page,
    percentileOptions,
    itemIdToExpandedRowMap = EMPTY_OBJECT,
    config = EMPTY_OBJECT,
    onSort = EMPTY_HANDLER,
    onPage = EMPTY_HANDLER,
    onRuleClick = EMPTY_HANDLER,
    onRuleEditClick = EMPTY_HANDLER,
    onRuleDeleteClick = EMPTY_HANDLER,
    onManageLicenseClick = EMPTY_HANDLER,
    onPercentileOptionsChange = EMPTY_HANDLER,
    onRuleChanged,
    onEnableRule,
    onDisableRule,
    onSnoozeRule = EMPTY_HANDLER,
    onUnsnoozeRule = EMPTY_HANDLER,
    onSelectAll = EMPTY_HANDLER,
    onSelectPage = EMPTY_HANDLER,
    onSelectRow = EMPTY_HANDLER,
    isRowSelected = () => false,
    renderCollapsedItemActions = EMPTY_RENDER,
    renderSelectAllDropdown,
    renderRuleError = EMPTY_RENDER,
    visibleColumns,
    resetFilters,
    numberOfFilters
  } = props;
  const [tagPopoverOpenIndex, setTagPopoverOpenIndex] = (0, _react.useState)(-1);
  const [isLoadingMap, setIsLoadingMap] = (0, _react.useState)({});
  const isRuleUsingExecutionStatus = (0, _get_experimental_features.getIsExperimentalFeatureEnabled)('ruleUseExecutionStatus');
  const [defaultNumberFormat] = (0, _public.useUiSetting$)(_constants.DEFAULT_NUMBER_FORMAT);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const ruleRowCss = (0, _react2.css)`
    .actRulesList__tableRowDisabled {
      background-color: ${euiTheme.colors.lightestShade};

      .actRulesList__tableCellDisabled {
        color: ${euiTheme.colors.darkShade};
      }
    }
    .euiTableRow {
      &:hover,
      &:focus-within,
      &[class*='-isActive'] {
        .ruleSidebarItem__action {
          opacity: 1;
        }
      }
    }
  `;
  const selectedPercentile = (0, _react.useMemo)(() => {
    const selectedOption = percentileOptions.find(option => option.checked === 'on');
    if (selectedOption) {
      return _types.Percentiles[selectedOption.key];
    }
  }, [percentileOptions]);
  const onLoading = (id, newIsLoading) => {
    setIsLoadingMap(prevState => ({
      ...prevState,
      [id]: newIsLoading
    }));
  };
  const renderPercentileColumnName = (0, _react.useCallback)(() => {
    return /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": `rulesTable-${selectedPercentile}ColumnName`
    }, selectedPercentile, "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.rulesListTable.columns.ruleExecutionPercentileTooltip', {
        defaultMessage: `{percentileOrdinal} percentile of this rule's past {sampleLimit} run durations (mm:ss).`,
        values: {
          percentileOrdinal: percentileOrdinals[selectedPercentile],
          sampleLimit: _common.MONITORING_HISTORY_LIMIT
        }
      }),
      size: "s",
      color: "subdued",
      type: "question",
      className: "eui-alignTop"
    }), /*#__PURE__*/_react.default.createElement(_percentile_selectable_popover.PercentileSelectablePopover, {
      options: percentileOptions,
      onOptionsChange: onPercentileOptionsChange
    }));
  }, [onPercentileOptionsChange, percentileOptions, selectedPercentile]);
  const renderPercentileCellValue = (0, _react.useCallback)(value => {
    return /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": `${selectedPercentile}Percentile`
    }, /*#__PURE__*/_react.default.createElement(_rule_duration_format.RuleDurationFormat, {
      allowZero: false,
      duration: value
    }));
  }, [selectedPercentile]);
  const isRuleTypeEditableInContext = (0, _react.useCallback)(ruleTypeId => ruleTypeRegistry.has(ruleTypeId) ? !ruleTypeRegistry.get(ruleTypeId).requiresAppContext : false, [ruleTypeRegistry]);
  const onDisableRuleInternal = (0, _react.useCallback)(rule => untrack => {
    return onDisableRule(rule, untrack);
  }, [onDisableRule]);
  const renderRuleStatusDropdown = (0, _react.useCallback)(rule => {
    return /*#__PURE__*/_react.default.createElement(_rule_status_dropdown.RuleStatusDropdown, {
      hideSnoozeOption: true,
      disableRule: onDisableRuleInternal(rule),
      enableRule: async () => await onEnableRule(rule),
      snoozeRule: async () => {},
      unsnoozeRule: async () => {},
      rule: rule,
      onRuleChanged: onRuleChanged,
      isEditable: rule.isEditable && isRuleTypeEditableInContext(rule.ruleTypeId),
      autoRecoverAlerts: rule.autoRecoverAlerts
    });
  }, [isRuleTypeEditableInContext, onDisableRuleInternal, onEnableRule, onRuleChanged]);
  const selectionColumn = (0, _react.useMemo)(() => {
    return {
      id: 'ruleSelection',
      field: 'selection',
      sortable: false,
      width: '32px',
      mobileOptions: {
        header: false
      },
      name: /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
        id: "rulesListTable_selectAll",
        checked: isPageSelected,
        onChange: onSelectPage,
        "data-test-subj": "checkboxSelectAll"
      }),
      render: (name, rule) => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
          id: `ruleListTable_select_${rule.id}}`,
          onChange: () => onSelectRow(rule),
          disabled: !rule.isEditable,
          checked: isRowSelected(rule),
          "data-test-subj": `checkboxSelectRow-${rule.id}`
        });
      }
    };
  }, [isPageSelected, onSelectPage, onSelectRow, isRowSelected]);
  const ruleOutcomeColumnField = (0, _react.useMemo)(() => {
    if (isRuleUsingExecutionStatus) {
      return 'executionStatus.status';
    }
    return 'lastRun.outcome';
  }, [isRuleUsingExecutionStatus]);
  const getRulesTableColumns = (0, _react.useCallback)(() => {
    return [{
      id: 'ruleName',
      field: 'name',
      name: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.rulesListTable.columns.nameTitle', {
        defaultMessage: 'Name'
      }),
      sortable: true,
      truncateText: false,
      width: '22%',
      'data-test-subj': 'rulesTableCell-name',
      render: (name, rule) => {
        const ruleType = ruleTypesState.data.get(rule.ruleTypeId);
        const checkEnabledResult = (0, _check_rule_type_enabled.checkRuleTypeEnabled)(ruleType);
        const link = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          direction: "column",
          gutterSize: "xs"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "xs"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          title: name,
          onClick: () => onRuleClick(rule)
        }, name)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, !checkEnabledResult.isEnabled && /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
          anchorClassName: "ruleDisabledQuestionIcon",
          css: (0, _react2.css)`
                            .ruleDisabledQuestionIcon {
                              bottom: ${euiTheme.size.xs};
                              margin-left: ${euiTheme.size.xs};
                              position: relative;
                            }
                          `,
          "data-test-subj": "ruleDisabledByLicenseTooltip",
          type: "question",
          content: checkEnabledResult.message,
          position: "right"
        })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          color: "subdued",
          size: "xs"
        }, rule.ruleType))));
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, link);
      }
    }, {
      id: 'ruleTags',
      field: 'tags',
      selectorName: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.rulesListTable.columns.selector.tagsTitle', {
        defaultMessage: 'Tags'
      }),
      name: '',
      sortable: false,
      width: '50px',
      'data-test-subj': 'rulesTableCell-tagsPopover',
      render: (ruleTags, rule) => {
        return ruleTags.length > 0 ? /*#__PURE__*/_react.default.createElement(_rule_tag_badge.RuleTagBadge, {
          isOpen: tagPopoverOpenIndex === rule.index,
          tags: ruleTags,
          onClick: () => setTagPopoverOpenIndex(rule.index),
          onClose: () => setTagPopoverOpenIndex(-1)
        }) : null;
      }
    }, {
      id: 'ruleExecutionStatusLastDate',
      field: 'executionStatus.lastExecutionDate',
      selectorName: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.rulesListTable.columns.selector.lastRunTitle', {
        defaultMessage: 'Last run'
      }),
      name: /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.rulesListTable.columns.lastRunTitle', {
        defaultMessage: 'Last run'
      }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        "data-test-subj": "rulesTableCell-lastExecutionDateTooltip",
        content: LAST_RUN_CONTENT,
        size: "s",
        color: "subdued",
        type: "question",
        className: "eui-alignTop",
        "aria-label": LAST_RUN_CONTENT
      })),
      sortable: true,
      width: '20%',
      'data-test-subj': 'rulesTableCell-lastExecutionDate',
      render: date => {
        if (date) {
          return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
            direction: "column",
            gutterSize: "none"
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false
          }, (0, _moment.default)(date).format('MMM D, YYYY HH:mm:ssa')), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            color: "subdued",
            size: "xs"
          }, (0, _moment.default)(date).fromNow()))));
        }
      }
    }, {
      id: 'ruleSnoozeNotify',
      selectorName: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.rulesListTable.columns.selector.notifyTitle', {
        defaultMessage: 'Notify'
      }),
      name: /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.rulesListTable.columns.notifyTitle', {
        defaultMessage: 'Notify'
      }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        "data-test-subj": "rulesTableCell-notifyTooltip",
        content: SNOOZE_RULE_NOTIFICATIONS,
        size: "s",
        color: "subdued",
        type: "question",
        className: "eui-alignTop",
        "aria-label": SNOOZE_RULE_NOTIFICATIONS
      })),
      width: '100px',
      'data-test-subj': 'rulesTableCell-rulesListNotify',
      render: rule => {
        if (!rule.enabled) {
          return null;
        }
        return /*#__PURE__*/_react.default.createElement("div", {
          "data-test-subj": `ruleType_${rule.ruleTypeId}`
        }, /*#__PURE__*/_react.default.createElement(_notify_badge.RulesListNotifyBadge, {
          showOnHover: true,
          snoozeSettings: rule,
          loading: !!isLoadingMap[rule.id],
          disabled: !rule.isEditable,
          onRuleChanged: onRuleChanged,
          snoozeRule: async snoozeSchedule => {
            await onSnoozeRule(rule, snoozeSchedule);
          },
          unsnoozeRule: async scheduleIds => await onUnsnoozeRule(rule, scheduleIds),
          isRuleEditable: rule.isEditable
        }));
      }
    }, {
      id: 'ruleScheduleInterval',
      field: 'schedule.interval',
      width: '6%',
      name: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.rulesListTable.columns.scheduleTitle', {
        defaultMessage: 'Interval'
      }),
      sortable: false,
      truncateText: false,
      'data-test-subj': 'rulesTableCell-interval',
      render: (interval, rule) => {
        const durationString = (0, _common.formatDuration)(interval);
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          direction: "row",
          gutterSize: "xs"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, durationString), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, rule.showIntervalWarning && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          "data-test-subj": `ruleInterval-config-tooltip-${rule.index}`,
          title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.rulesListTable.columns.intervalTooltipTitle', {
            defaultMessage: 'Below configured minimum interval'
          }),
          content: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.rulesListTable.columns.intervalTooltipText', {
            defaultMessage: 'Rule interval of {interval} is below the minimum configured interval of {minimumInterval}. This may impact alerting performance.',
            values: {
              minimumInterval: (0, _common.formatDuration)(config.minimumScheduleInterval.value, true),
              interval: (0, _common.formatDuration)(interval, true)
            }
          }),
          position: "top"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
          color: "text",
          "data-test-subj": `ruleInterval-config-icon-${rule.index}`,
          onClick: () => onRuleEditClick(rule),
          iconType: "flag",
          "aria-label": _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.rulesListTable.columns.intervalIconAriaLabel', {
            defaultMessage: 'Below configured minimum interval'
          })
        })))));
      }
    }, {
      id: 'ruleExecutionStatusLastDuration',
      field: 'executionStatus.lastDuration',
      width: '12%',
      selectorName: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.rulesListTable.columns.selector.durationTitle', {
        defaultMessage: 'Duration'
      }),
      name: /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.rulesListTable.columns.durationTitle', {
        defaultMessage: 'Duration'
      }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        "data-test-subj": "rulesTableCell-durationTooltip",
        content: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.rulesListTable.columns.durationTitleTooltip', {
          defaultMessage: 'The length of time it took for the rule to run (mm:ss).'
        }),
        size: "s",
        color: "subdued",
        type: "question",
        className: "eui-alignTop"
      })),
      sortable: true,
      truncateText: false,
      'data-test-subj': 'rulesTableCell-duration',
      render: (value, rule) => {
        const showDurationWarning = (0, _execution_duration_utils.shouldShowDurationWarning)(ruleTypesState.data.get(rule.ruleTypeId), value);
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_rule_duration_format.RuleDurationFormat, {
          duration: value
        }), showDurationWarning && /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
          "data-test-subj": "ruleDurationWarning",
          anchorClassName: "ruleDurationWarningIcon",
          css: (0, _react2.css)`
                    .ruleDurationWarningIcon {
                      margin-bottom: ${euiTheme.size.xs};
                      margin-left: ${euiTheme.size.s};
                    }
                  `,
          type: "warning",
          color: "warning",
          content: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.ruleTypeExcessDurationMessage', {
            defaultMessage: `Duration exceeds the rule's expected run time.`
          }),
          position: "right"
        }));
      }
    }, {
      id: 'ruleExecutionPercentile',
      mobileOptions: {
        header: false
      },
      selectorName: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.rulesListTable.columns.selector.percentileTitle', {
        defaultMessage: 'Percentile'
      }),
      field: percentileFields[selectedPercentile],
      width: '16%',
      name: renderPercentileColumnName(),
      'data-test-subj': 'rulesTableCell-ruleExecutionPercentile',
      sortable: true,
      truncateText: false,
      render: renderPercentileCellValue
    }, {
      id: 'ruleExecutionSuccessRatio',
      field: 'monitoring.run.calculated_metrics.success_ratio',
      width: '12%',
      selectorName: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.rulesListTable.columns.selector.successRatioTitle', {
        defaultMessage: 'Success ratio'
      }),
      name: /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.rulesListTable.columns.successRatioTitle', {
        defaultMessage: 'Success ratio'
      }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        "data-test-subj": "rulesTableCell-successRatioTooltip",
        content: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.rulesListTable.columns.successRatioTitleTooltip', {
          defaultMessage: 'How often this rule runs successfully.'
        }),
        size: "s",
        color: "subdued",
        type: "question",
        className: "eui-alignTop"
      })),
      sortable: true,
      truncateText: false,
      'data-test-subj': 'rulesTableCell-successRatio',
      render: value => {
        return /*#__PURE__*/_react.default.createElement("span", {
          "data-test-subj": "successRatio"
        }, value !== undefined ? (0, _monitoring_utils.getFormattedSuccessRatio)(value) : 'N/A');
      }
    }, {
      id: 'ruleExecutionStatus',
      field: ruleOutcomeColumnField,
      name: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.rulesListTable.columns.lastResponseTitle', {
        defaultMessage: 'Last response'
      }),
      sortable: true,
      truncateText: false,
      width: '120px',
      'data-test-subj': 'rulesTableCell-lastResponse',
      render: (_executionStatus, rule) => {
        return /*#__PURE__*/_react.default.createElement(_rules_list_table_status_cell.RulesListTableStatusCell, {
          rule: rule,
          onManageLicenseClick: onManageLicenseClick
        });
      }
    }, {
      id: 'ruleExecutionState',
      field: 'enabled',
      name: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.rulesListTable.columns.stateTitle', {
        defaultMessage: 'State'
      }),
      sortable: true,
      truncateText: false,
      width: '100px',
      'data-test-subj': 'rulesTableCell-status',
      render: (_enabled, rule) => {
        return renderRuleStatusDropdown(rule);
      }
    }, {
      name: '',
      width: '90px',
      render(rule) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          justifyContent: "flexEnd",
          gutterSize: "none",
          "data-test-subj": `ruleType_${rule.ruleTypeId}`
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          className: "ruleSidebarItem"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          justifyContent: "flexEnd",
          gutterSize: "xs"
        }, rule.isEditable && isRuleTypeEditableInContext(rule.ruleTypeId) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          "data-test-subj": "ruleSidebarEditAction"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
          color: 'primary',
          title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.rulesListTable.columns.editButtonTooltip', {
            defaultMessage: 'Edit'
          }),
          className: "ruleSidebarItem__action",
          css: ruleSidebarActionCss,
          "data-test-subj": "editActionHoverButton",
          onClick: () => onRuleEditClick(rule),
          iconType: 'pencil',
          "aria-label": _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.rulesListTable.columns.editAriaLabel', {
            defaultMessage: 'Edit'
          }),
          disabled: !rule.enabledInLicense
        })) : null, rule.isEditable ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          "data-test-subj": "ruleSidebarDeleteAction"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
          color: 'danger',
          title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.rulesListTable.columns.deleteButtonTooltip', {
            defaultMessage: 'Delete'
          }),
          className: "ruleSidebarItem__action",
          css: ruleSidebarActionCss,
          "data-test-subj": "deleteActionHoverButton",
          onClick: () => onRuleDeleteClick(rule),
          iconType: 'trash',
          "aria-label": _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.rulesListTable.columns.deleteAriaLabel', {
            defaultMessage: 'Delete "{name}"',
            values: {
              name: rule.name
            }
          })
        })) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, renderCollapsedItemActions(rule, newIsLoading => onLoading(rule.id, newIsLoading))));
      }
    }, {
      align: _eui.RIGHT_ALIGNMENT,
      width: '40px',
      isExpander: true,
      name: /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("span", null, "Expand rows")),
      render: renderRuleError
    }];
  }, [config.minimumScheduleInterval, isLoadingMap, isRuleTypeEditableInContext, onRuleChanged, onRuleClick, onRuleDeleteClick, onRuleEditClick, onSnoozeRule, onUnsnoozeRule, onManageLicenseClick, renderCollapsedItemActions, renderPercentileCellValue, renderPercentileColumnName, renderRuleError, renderRuleStatusDropdown, ruleTypesState.data, selectedPercentile, tagPopoverOpenIndex, ruleOutcomeColumnField, euiTheme]);
  const allRuleColumns = (0, _react.useMemo)(() => getRulesTableColumns(), [getRulesTableColumns]);
  const [rulesListColumns, ColumnSelector] = (0, _rules_list_column_selector.useRulesListColumnSelector)({
    allRuleColumns,
    rulesListKey,
    visibleColumns
  });
  const formattedTotalRules = (0, _react.useMemo)(() => {
    return (0, _numeral.default)(rulesState.totalItemCount).format(defaultNumberFormat);
  }, [rulesState.totalItemCount, defaultNumberFormat]);
  const selectAllButtonText = (0, _react.useMemo)(() => {
    if (isAllSelected) {
      return _translations.CLEAR_SELECTION;
    }
    return (0, _translations.SELECT_ALL_RULES)(formattedTotalRules, rulesState.totalItemCount);
  }, [isAllSelected, formattedTotalRules, rulesState.totalItemCount]);
  const rowProps = (0, _react.useCallback)(rule => {
    var _ruleTypesState$data$;
    const selectedClass = isRowSelected(rule) ? 'euiTableRow-isSelected' : '';
    return {
      'data-test-subj': 'rule-row',
      className: !((_ruleTypesState$data$ = ruleTypesState.data.get(rule.ruleTypeId)) !== null && _ruleTypesState$data$ !== void 0 && _ruleTypesState$data$.enabledInLicense) ? `actRulesList__tableRowDisabled ${selectedClass}` : selectedClass
    };
  }, [ruleTypesState, isRowSelected]);
  const authorizedToModifyAllRules = (0, _react.useMemo)(() => {
    let authorized = true;
    ruleTypesState.data.forEach(ruleType => {
      if (!authorized) {
        return;
      }
      const allConsumersAuthorized = Object.values(ruleType.authorizedConsumers).every(authorizedConsumer => authorizedConsumer.all);
      if (!allConsumersAuthorized) {
        authorized = false;
      }
    });
    return authorized;
  }, [ruleTypesState]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    gutterSize: "none",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, numberOfSelectedRules > 0 ? renderSelectAllDropdown === null || renderSelectAllDropdown === void 0 ? void 0 : renderSelectAllDropdown() : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    style: {
      fontWeight: euiTheme.font.weight.semiBold
    },
    "data-test-subj": "totalRulesCount"
  }, (0, _translations.TOTAL_RULES)(formattedTotalRules, rulesState.totalItemCount))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, numberOfSelectedRules > 0 && authorizedToModifyAllRules && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    "aria-label": _translations.SELECT_ALL_ARIA_LABEL,
    "data-test-subj": "selectAllRulesButton",
    iconType: isAllSelected ? 'cross' : 'pagesSelect',
    onClick: onSelectAll
  }, selectAllButtonText)), numberOfFilters > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      borderLeft: euiTheme.border.thin,
      paddingLeft: euiTheme.size.m
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: resetFilters,
    size: "xs",
    iconSide: "left",
    flush: "left",
    "data-test-subj": "rules-list-clear-filter"
  }, (0, _translations.CLEAR_FILTERS)(numberOfFilters))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, ColumnSelector)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    loading: isLoading
    /* Don't display rules until we have the rule types initialized */,
    items: items,
    itemId: "id",
    columns: [selectionColumn, ...rulesListColumns],
    sorting: {
      sort
    },
    rowHeader: "name",
    rowProps: rowProps,
    css: ruleRowCss,
    cellProps: rule => {
      var _ruleTypesState$data$2;
      return {
        'data-test-subj': 'cell',
        className: !((_ruleTypesState$data$2 = ruleTypesState.data.get(rule.ruleTypeId)) !== null && _ruleTypesState$data$2 !== void 0 && _ruleTypesState$data$2.enabledInLicense) ? 'actRulesList__tableCellDisabled' : ''
      };
    },
    "data-test-subj": "rulesList",
    pagination: {
      pageIndex: page.index,
      pageSize: page.size,
      /* Don't display rule count until we have the rule types initialized */
      totalItemCount: ruleTypesState.isInitialLoad ? 0 : rulesState.totalItemCount
    },
    onChange: ({
      page: changedPage,
      sort: changedSort
    }) => {
      if (changedPage) {
        onPage(changedPage);
      }
      if (changedSort) {
        onSort(changedSort);
      }
    },
    itemIdToExpandedRowMap: itemIdToExpandedRowMap
  })));
};
exports.RulesListTable = RulesListTable;