"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WEEKS = exports.ONE = exports.MONTHS = exports.MINUTES = exports.HOURS = exports.DAYS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MINUTES = exports.MINUTES = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.minutesLabel', {
  defaultMessage: 'minutes'
});
const HOURS = exports.HOURS = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.hoursLabel', {
  defaultMessage: 'hours'
});
const DAYS = exports.DAYS = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.daysLabel', {
  defaultMessage: 'days'
});
const WEEKS = exports.WEEKS = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.weeksLabel', {
  defaultMessage: 'weeks'
});
const MONTHS = exports.MONTHS = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.monthsLabel', {
  defaultMessage: 'months'
});

// i18n constants to override moment.humanize
const ONE = exports.ONE = {
  m: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.snoozeOneMinute', {
    defaultMessage: '1 minute'
  }),
  h: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.snoozeOneHour', {
    defaultMessage: '1 hour'
  }),
  d: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.snoozeOneDay', {
    defaultMessage: '1 day'
  }),
  w: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.snoozeOneWeek', {
    defaultMessage: '1 week'
  }),
  M: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.snoozeOneMonth', {
    defaultMessage: '1 month'
  })
};