"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventLogListStatus = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _translations = require("../../../rules_list/translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const statusContainerStyles = {
  display: 'flex',
  alignItems: 'center',
  textTransform: 'capitalize'
};
const iconStyles = {
  marginRight: '8px'
};
const STATUS_TO_COLOR = {
  success: 'success',
  failure: 'danger',
  unknown: 'gray',
  warning: 'warning'
};
const STATUS_TO_OUTCOME = {
  success: _translations.RULE_LAST_RUN_OUTCOME_SUCCEEDED,
  failure: _translations.RULE_LAST_RUN_OUTCOME_FAILED,
  warning: _translations.RULE_LAST_RUN_OUTCOME_WARNING,
  unknown: _translations.ALERT_STATUS_UNKNOWN
};
const EventLogListStatus = props => {
  const {
    status,
    useExecutionStatus = true
  } = props;
  const color = STATUS_TO_COLOR[status] || 'gray';
  const statusString = (0, _react.useMemo)(() => {
    if (useExecutionStatus) {
      return status;
    }
    return STATUS_TO_OUTCOME[status].toLocaleLowerCase();
  }, [useExecutionStatus, status]);
  return /*#__PURE__*/_react.default.createElement("span", {
    style: statusContainerStyles,
    "data-test-subj": "eventLogListStatus"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "dot",
    color: color,
    style: iconStyles
  }), statusString);
};
exports.EventLogListStatus = EventLogListStatus;