"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRulesListUiState = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFilterApplied = ({
  hasEmptyTypesFilter,
  filters
}) => {
  return !(hasEmptyTypesFilter && (0, _lodash.isEmpty)(filters.searchText) && (0, _lodash.isEmpty)(filters.actionTypes) && (0, _lodash.isEmpty)(filters.ruleExecutionStatuses) && (0, _lodash.isEmpty)(filters.ruleLastRunOutcomes) && (0, _lodash.isEmpty)(filters.ruleStatuses) && (0, _lodash.isEmpty)(filters.tags));
};
const useRulesListUiState = ({
  authorizedToReadAnyRules,
  authorizedToCreateAnyRules,
  filters,
  hasDefaultRuleTypesFiltersOn,
  isLoadingRuleTypes,
  isLoadingRules,
  isInitialLoadingRuleTypes,
  isInitialLoadingRules,
  hasData
}) => {
  const hasEmptyTypesFilter = hasDefaultRuleTypesFiltersOn ? true : (0, _lodash.isEmpty)(filters.types);
  const isFilterApplied = getFilterApplied({
    hasEmptyTypesFilter,
    filters
  });
  const isInitialLoading = isInitialLoadingRuleTypes || isInitialLoadingRules;
  const isLoading = isLoadingRuleTypes || isLoadingRules;
  const showNoAuthPrompt = !isInitialLoadingRuleTypes && !authorizedToReadAnyRules;
  const showCreateFirstRulePrompt = !isLoading && !hasData && !isFilterApplied && authorizedToCreateAnyRules;
  const showSpinner = isInitialLoading && (isLoadingRuleTypes || !showNoAuthPrompt && isLoadingRules);
  const showRulesList = !showSpinner && !showCreateFirstRulePrompt && !showNoAuthPrompt;
  return {
    showSpinner,
    showRulesList,
    showNoAuthPrompt,
    showCreateFirstRulePrompt
  };
};
exports.useRulesListUiState = useRulesListUiState;