"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLoadActionTypesQuery = void 0;
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@kbn/react-query");
var _common = require("@kbn/actions-plugin/common");
var _kibana = require("../../common/lib/kibana");
var _action_connector_api = require("../lib/action_connector_api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLoadActionTypesQuery = () => {
  const {
    http,
    actionTypeRegistry,
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const queryFn = () => {
    return (0, _action_connector_api.loadActionTypes)({
      http,
      featureId: _common.AlertingConnectorFeatureId
    });
  };
  const onErrorFn = () => {
    toasts.addDanger(_i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.unableToLoadConnectorTypesMessage', {
      defaultMessage: 'Unable to load connector types'
    }));
  };
  const {
    data = []
  } = (0, _reactQuery.useQuery)({
    queryKey: ['loadActionTypes'],
    queryFn,
    onError: onErrorFn,
    refetchOnWindowFocus: false
  });
  const sortedResult = data.filter(({
    id
  }) => actionTypeRegistry.has(id)).sort((a, b) => a.name.localeCompare(b.name));
  return {
    actionTypes: sortedResult
  };
};
exports.useLoadActionTypesQuery = useLoadActionTypesQuery;