"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeFormSection = void 0;
var _mlIsDefined = require("@kbn/ml-is-defined");
var _mlNestedProperty = require("@kbn/ml-nested-property");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Defining these sections is only necessary for options where a reset/deletion of that part of the
// configuration is supported by the API. For example, this isn't suitable to use with `dest` since
// this overall part of the configuration is not optional. However, `retention_policy` is optional,
// so we need to support to recognize this based on the form state and be able to reset it by
// creating a request body containing `{ retention_policy: null }`.

const initializeFormSection = (formSectionName, configFieldName, config, overloads) => {
  var _overloads$defaultEna;
  const defaultEnabled = (_overloads$defaultEna = overloads === null || overloads === void 0 ? void 0 : overloads.defaultEnabled) !== null && _overloads$defaultEna !== void 0 ? _overloads$defaultEna : false;
  const rawEnabled = (0, _mlNestedProperty.getNestedProperty)(config !== null && config !== void 0 ? config : {}, configFieldName, undefined);
  const enabled = (0, _mlIsDefined.isDefined)(rawEnabled);
  return {
    formSectionName,
    configFieldName,
    defaultEnabled,
    enabled
  };
};
exports.initializeFormSection = initializeFormSection;