"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSearchItems = createSearchItems;
var _esQuery = require("@kbn/es-query");
var _public = require("@kbn/data-plugin/public");
var _mlQueryUtils = require("@kbn/ml-query-utils");
var _data_view = require("../../../../common/types/data_view");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Helper for creating the items used for searching and job creation.
function createSearchItems(dataView, savedSearch, config) {
  // query is only used by the data visualizer as it needs
  // a lucene query_string.
  // Using a blank query will cause match_all:{} to be used
  // when passed through luceneStringToDsl
  let query = {
    query: '',
    language: 'lucene'
  };
  let combinedQuery = {
    bool: {
      must: [_mlQueryUtils.matchAllQuery]
    }
  };
  if (!(0, _data_view.isDataView)(dataView) && savedSearch !== null && savedSearch.id !== undefined) {
    const searchSource = savedSearch.searchSource;
    dataView = searchSource.getField('index');
    query = searchSource.getField('query');
    const fs = searchSource.getField('filter');
    const filters = fs.length ? fs : [];
    const esQueryConfigs = (0, _public.getEsQueryConfig)(config);
    combinedQuery = (0, _esQuery.buildEsQuery)(dataView, [query], filters, esQueryConfigs);
  }
  if (!(0, _data_view.isDataView)(dataView)) {
    throw new Error('Data view is not defined.');
  }
  return {
    dataView,
    savedSearch,
    query,
    combinedQuery
  };
}