"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataSearch = void 0;
var _reactQuery = require("@kbn/react-query");
var _rxjs = require("rxjs");
var _constants = require("../../../common/constants");
var _app_dependencies = require("../app_dependencies");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDataSearch = (esSearchRequestParams, enabled) => {
  const {
    data
  } = (0, _app_dependencies.useAppDependencies)();
  return (0, _reactQuery.useQuery)([_constants.TRANSFORM_REACT_QUERY_KEYS.DATA_SEARCH, esSearchRequestParams], async ({
    signal
  }) => {
    const {
      rawResponse: resp
    } = await (0, _rxjs.lastValueFrom)(data.search.search({
      params: esSearchRequestParams
    }, {
      abortSignal: signal
    }));
    return resp;
  }, {
    enabled
  });
};
exports.useDataSearch = useDataSearch;