"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCurrentDataViewFields = void 0;
var _react = require("react");
var _use_sourcerer_data_view = require("./use_sourcerer_data_view");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Custom hook to retrieve fields from the sourcerer data view.
 */
const useCurrentDataViewFields = () => {
  const {
    sourcererDataView
  } = (0, _use_sourcerer_data_view.useSourcererDataView)();
  return (0, _react.useMemo)(() => {
    var _sourcererDataView$fi;
    return Object.values((_sourcererDataView$fi = sourcererDataView.fields) !== null && _sourcererDataView$fi !== void 0 ? _sourcererDataView$fi : {});
  }, [sourcererDataView.fields]);
};
exports.useCurrentDataViewFields = useCurrentDataViewFields;