"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.scheduleRruleSchema = exports.rruleSchedule = void 0;
var _configSchema = require("@kbn/config-schema");
var _rrule = require("@kbn/rrule");
var _v = require("./v1");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const validateStartDate = date => {
  const parsedValue = Date.parse(date);
  if (isNaN(parsedValue)) return `Invalid date: ${date}`;
  return;
};
const rruleCommon = _v.rruleCommon.extends({
  dtstart: _configSchema.schema.maybe(_configSchema.schema.string({
    validate: validateStartDate
  }))
});
const rruleMonthly = rruleCommon.extends({
  freq: _configSchema.schema.literal(_rrule.Frequency.MONTHLY),
  byhour: _v.byhour,
  byminute: _v.byminute,
  byweekday: _v.byweekday,
  bymonthday: _v.bymonthday
});
const rruleWeekly = rruleCommon.extends({
  freq: _configSchema.schema.literal(_rrule.Frequency.WEEKLY),
  byhour: _v.byhour,
  byminute: _v.byminute,
  byweekday: _v.byweekday,
  bymonthday: _configSchema.schema.never()
});
const rruleDaily = rruleCommon.extends({
  freq: _configSchema.schema.literal(_rrule.Frequency.DAILY),
  byhour: _v.byhour,
  byminute: _v.byminute,
  byweekday: _v.byweekday,
  bymonthday: _configSchema.schema.never()
});
const rruleSchedule = exports.rruleSchedule = _configSchema.schema.oneOf([rruleMonthly, rruleWeekly, rruleDaily]);
const scheduleRruleSchema = exports.scheduleRruleSchema = _configSchema.schema.object({
  rrule: rruleSchedule
});