"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TaskPartitioner = exports.MAX_PARTITIONS = exports.CACHE_INTERVAL = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _assign_pod_partitions = require("./assign_pod_partitions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function range(start, end) {
  const nums = [];
  for (let i = start; i < end; ++i) {
    nums.push(i);
  }
  return nums;
}
const MAX_PARTITIONS = exports.MAX_PARTITIONS = 256;
const CACHE_INTERVAL = exports.CACHE_INTERVAL = 10000;
class TaskPartitioner {
  constructor(opts) {
    (0, _defineProperty2.default)(this, "allPartitions", void 0);
    (0, _defineProperty2.default)(this, "podName", void 0);
    (0, _defineProperty2.default)(this, "kibanasPerPartition", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "kibanaDiscoveryService", void 0);
    (0, _defineProperty2.default)(this, "podPartitions", void 0);
    (0, _defineProperty2.default)(this, "podPartitionsLastUpdated", void 0);
    this.allPartitions = range(0, MAX_PARTITIONS);
    this.podName = opts.podName;
    this.kibanasPerPartition = opts.kibanasPerPartition;
    this.kibanaDiscoveryService = opts.kibanaDiscoveryService;
    this.podPartitions = [];
    this.podPartitionsLastUpdated = Date.now() - CACHE_INTERVAL;
    this.logger = opts.logger;
  }
  getAllPartitions() {
    return this.allPartitions;
  }
  getPodName() {
    return this.podName;
  }
  getPodPartitions() {
    return this.podPartitions;
  }
  async getPartitions() {
    const lastUpdated = new Date(this.podPartitionsLastUpdated).getTime();
    const now = Date.now();

    // update the pod partitions cache after 10 seconds or when no partitions were previously found
    if (now - lastUpdated >= CACHE_INTERVAL || this.podPartitions.length === 0) {
      try {
        const allPodNames = await this.getAllPodNames();
        this.podPartitions = (0, _assign_pod_partitions.assignPodPartitions)({
          kibanasPerPartition: this.kibanasPerPartition,
          podName: this.podName,
          podNames: allPodNames,
          partitions: this.allPartitions
        });
        this.podPartitionsLastUpdated = now;
      } catch (error) {
        this.logger.error(`Failed to load list of active kibana nodes: ${error.message}`);
        // return the cached value
        return this.podPartitions;
      }
    }
    return this.podPartitions;
  }
  async getAllPodNames() {
    const nodes = await this.kibanaDiscoveryService.getActiveKibanaNodes();
    return nodes.map(node => node.attributes.id);
  }
}
exports.TaskPartitioner = TaskPartitioner;