"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rootReducer = void 0;
var _toolkit = require("@reduxjs/toolkit");
var _maintenance_windows = require("./maintenance_windows");
var _certs = require("./certs");
var _certificates = require("./certificates/certificates");
var _global_params = require("./global_params");
var _overview_status = require("./overview_status");
var _browser_journey = require("./browser_journey");
var _alert_rules = require("./alert_rules");
var _manual_test_runs = require("./manual_test_runs");
var _settings = require("./settings");
var _elasticsearch = require("./elasticsearch");
var _private_locations = require("./private_locations");
var _network_events = require("./network_events");
var _monitor_details = require("./monitor_details");
var _ui = require("./ui");
var _synthetics_enablement = require("./synthetics_enablement");
var _monitor_list = require("./monitor_list");
var _service_locations = require("./service_locations");
var _overview = require("./overview");
var _status_heatmap = require("./status_heatmap");
var _agent_policies = require("./agent_policies");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rootReducer = exports.rootReducer = (0, _toolkit.combineReducers)({
  agentPolicies: _agent_policies.agentPoliciesReducer,
  browserJourney: _browser_journey.browserJourneyReducer,
  certificates: _certificates.certificatesReducer,
  certsList: _certs.certsListReducer,
  defaultAlerting: _alert_rules.defaultAlertingReducer,
  dynamicSettings: _settings.dynamicSettingsReducer,
  elasticsearch: _elasticsearch.elasticsearchReducer,
  globalParams: _global_params.globalParamsReducer,
  manualTestRuns: _manual_test_runs.manualTestRunsReducer,
  monitorDetails: _monitor_details.monitorDetailsReducer,
  monitorList: _monitor_list.monitorListReducer,
  monitorStatusHeatmap: _status_heatmap.monitorStatusHeatmapReducer,
  networkEvents: _network_events.networkEventsReducer,
  overview: _overview.monitorOverviewReducer,
  overviewStatus: _overview_status.overviewStatusReducer,
  privateLocations: _private_locations.privateLocationsStateReducer,
  serviceLocations: _service_locations.serviceLocationsReducer,
  syntheticsEnablement: _synthetics_enablement.syntheticsEnablementReducer,
  ui: _ui.uiReducer,
  maintenanceWindows: _maintenance_windows.maintenanceWindowsReducer
});