"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStepMetrics = exports.TRANSFER_SIZE = exports.SYNTHETICS_STEP_NAME = exports.SYNTHETICS_STEP_DURATION = exports.SYNTHETICS_ONLOAD_EVENT = exports.SYNTHETICS_LCP = exports.SYNTHETICS_FCP = exports.SYNTHETICS_DCL = exports.SYNTHETICS_CLS = exports.STEP_DURATION_LABEL = exports.MONITOR_DURATION_US = exports.LCP_LABEL = exports.FCP_LABEL = exports.DCL_LABEL = exports.CLS_LABEL = void 0;
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _use_redux_es_search = require("../../../hooks/use_redux_es_search");
var _use_object_metrics = require("./use_object_metrics");
var _step_metrics = require("../step_metrics/step_metrics");
var _labels = require("../step_metrics/labels");
var _constants = require("../../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MONITOR_DURATION_US = exports.MONITOR_DURATION_US = 'monitor.duration.us';
const SYNTHETICS_CLS = exports.SYNTHETICS_CLS = 'browser.experience.cls';
const SYNTHETICS_LCP = exports.SYNTHETICS_LCP = 'browser.experience.lcp.us';
const SYNTHETICS_FCP = exports.SYNTHETICS_FCP = 'browser.experience.fcp.us';
const SYNTHETICS_ONLOAD_EVENT = exports.SYNTHETICS_ONLOAD_EVENT = 'browser.experience.load.us';
const SYNTHETICS_DCL = exports.SYNTHETICS_DCL = 'browser.experience.dcl.us';
const SYNTHETICS_STEP_NAME = exports.SYNTHETICS_STEP_NAME = 'synthetics.step.name.keyword';
const SYNTHETICS_STEP_DURATION = exports.SYNTHETICS_STEP_DURATION = 'synthetics.step.duration.us';
const useStepMetrics = step => {
  var _step$monitor$check_g, _step$synthetics$step, _step$synthetics$step2, _transferData$aggrega, _transferData$aggrega2, _transferData$aggrega3, _metrics$totalDuratio, _metrics$lcp$value, _metrics$fcp$value, _metrics$cls$value, _metrics$dcl$value;
  const urlParams = (0, _reactRouterDom.useParams)();
  const checkGroupId = (_step$monitor$check_g = step === null || step === void 0 ? void 0 : step.monitor.check_group) !== null && _step$monitor$check_g !== void 0 ? _step$monitor$check_g : urlParams.checkGroupId;
  const stepIndex = (_step$synthetics$step = step === null || step === void 0 ? void 0 : (_step$synthetics$step2 = step.synthetics.step) === null || _step$synthetics$step2 === void 0 ? void 0 : _step$synthetics$step2.index) !== null && _step$synthetics$step !== void 0 ? _step$synthetics$step : urlParams.stepIndex;
  const {
    data
  } = (0, _use_redux_es_search.useReduxEsSearch)({
    index: _constants.SYNTHETICS_INDEX_PATTERN,
    body: {
      size: 0,
      query: {
        bool: {
          filter: [{
            terms: {
              'synthetics.type': ['step/metrics', 'step/end']
            }
          }, {
            term: {
              'monitor.check_group': checkGroupId
            }
          }, {
            term: {
              'synthetics.step.index': Number(stepIndex)
            }
          }]
        }
      },
      aggs: {
        fcp: {
          sum: {
            field: SYNTHETICS_FCP
          }
        },
        lcp: {
          sum: {
            field: SYNTHETICS_LCP
          }
        },
        cls: {
          sum: {
            field: SYNTHETICS_CLS
          }
        },
        dcl: {
          sum: {
            field: SYNTHETICS_DCL
          }
        },
        totalDuration: {
          sum: {
            field: SYNTHETICS_STEP_DURATION
          }
        }
      }
    }
  }, [], {
    name: `stepMetrics/${checkGroupId}/${stepIndex}`
  });
  const {
    data: transferData
  } = (0, _use_redux_es_search.useReduxEsSearch)({
    index: _constants.SYNTHETICS_INDEX_PATTERN,
    body: {
      size: 0,
      runtime_mappings: {
        'synthetics.payload.transfer_size': {
          type: 'double'
        }
      },
      query: {
        bool: {
          filter: [{
            term: {
              'synthetics.type': 'journey/network_info'
            }
          }, {
            term: {
              'monitor.check_group': checkGroupId
            }
          }, {
            term: {
              'synthetics.step.index': Number(stepIndex)
            }
          }]
        }
      },
      aggs: {
        transferSize: {
          sum: {
            field: 'synthetics.payload.transfer_size'
          }
        }
      }
    }
  }, [], {
    name: `stepMetricsFromNetworkInfos/${checkGroupId}/${stepIndex}`
  });
  const metrics = data === null || data === void 0 ? void 0 : data.aggregations;
  const transferDataVal = (_transferData$aggrega = transferData === null || transferData === void 0 ? void 0 : (_transferData$aggrega2 = transferData.aggregations) === null || _transferData$aggrega2 === void 0 ? void 0 : (_transferData$aggrega3 = _transferData$aggrega2.transferSize) === null || _transferData$aggrega3 === void 0 ? void 0 : _transferData$aggrega3.value) !== null && _transferData$aggrega !== void 0 ? _transferData$aggrega : 0;
  return {
    metrics: [{
      label: STEP_DURATION_LABEL,
      value: metrics === null || metrics === void 0 ? void 0 : metrics.totalDuration.value,
      formatted: (0, _step_metrics.formatMillisecond)(((_metrics$totalDuratio = metrics === null || metrics === void 0 ? void 0 : metrics.totalDuration.value) !== null && _metrics$totalDuratio !== void 0 ? _metrics$totalDuratio : 0) / 1000)
    }, {
      value: metrics === null || metrics === void 0 ? void 0 : metrics.lcp.value,
      label: LCP_LABEL,
      helpText: _labels.LCP_HELP_LABEL,
      formatted: (0, _step_metrics.formatMillisecond)(((_metrics$lcp$value = metrics === null || metrics === void 0 ? void 0 : metrics.lcp.value) !== null && _metrics$lcp$value !== void 0 ? _metrics$lcp$value : 0) / 1000)
    }, {
      value: metrics === null || metrics === void 0 ? void 0 : metrics.fcp.value,
      label: FCP_LABEL,
      helpText: _labels.FCP_TOOLTIP,
      formatted: (0, _step_metrics.formatMillisecond)(((_metrics$fcp$value = metrics === null || metrics === void 0 ? void 0 : metrics.fcp.value) !== null && _metrics$fcp$value !== void 0 ? _metrics$fcp$value : 0) / 1000)
    }, {
      value: metrics === null || metrics === void 0 ? void 0 : metrics.cls.value,
      label: CLS_LABEL,
      helpText: _labels.CLS_HELP_LABEL,
      formatted: (_metrics$cls$value = metrics === null || metrics === void 0 ? void 0 : metrics.cls.value) !== null && _metrics$cls$value !== void 0 ? _metrics$cls$value : 0
    }, {
      value: metrics === null || metrics === void 0 ? void 0 : metrics.dcl.value,
      label: DCL_LABEL,
      helpText: _labels.DCL_TOOLTIP,
      formatted: (0, _step_metrics.formatMillisecond)(((_metrics$dcl$value = metrics === null || metrics === void 0 ? void 0 : metrics.dcl.value) !== null && _metrics$dcl$value !== void 0 ? _metrics$dcl$value : 0) / 1000)
    }, {
      value: transferDataVal,
      label: TRANSFER_SIZE,
      helpText: _labels.TRANSFER_SIZE_HELP,
      formatted: (0, _use_object_metrics.formatBytes)(transferDataVal !== null && transferDataVal !== void 0 ? transferDataVal : 0)
    }]
  };
};
exports.useStepMetrics = useStepMetrics;
const LCP_LABEL = exports.LCP_LABEL = _i18n.i18n.translate('xpack.synthetics.lcp.label', {
  defaultMessage: 'LCP'
});
const FCP_LABEL = exports.FCP_LABEL = _i18n.i18n.translate('xpack.synthetics.fcp.label', {
  defaultMessage: 'FCP'
});
const CLS_LABEL = exports.CLS_LABEL = _i18n.i18n.translate('xpack.synthetics.cls.label', {
  defaultMessage: 'CLS'
});
const DCL_LABEL = exports.DCL_LABEL = _i18n.i18n.translate('xpack.synthetics.dcl.label', {
  defaultMessage: 'DCL'
});
const STEP_DURATION_LABEL = exports.STEP_DURATION_LABEL = _i18n.i18n.translate('xpack.synthetics.totalDuration.metrics', {
  defaultMessage: 'Step duration'
});
const TRANSFER_SIZE = exports.TRANSFER_SIZE = _i18n.i18n.translate('xpack.synthetics.totalDuration.transferSize', {
  defaultMessage: 'Transfer size'
});