"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyName = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _i18n = require("@kbn/i18n");
var _contexts = require("../../../contexts");
var _hooks = require("../../../hooks");
var _agent_policies = require("../../../state/agent_policies");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PolicyName = ({
  agentPolicyId
}) => {
  const {
    canReadAgentPolicies
  } = (0, _hooks.useFleetPermissions)();
  const {
    basePath
  } = (0, _contexts.useSyntheticsSettingsContext)();
  const {
    data: policies,
    loading
  } = (0, _reactRedux.useSelector)(_agent_policies.selectAgentPolicies);
  const policy = policies === null || policies === void 0 ? void 0 : policies.find(policyT => policyT.id === agentPolicyId);
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "s"
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, canReadAgentPolicies ? /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, policy ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "syntheticsPolicyNameLink",
    href: `${basePath}/app/fleet/policies/${agentPolicyId}`
  }, policy === null || policy === void 0 ? void 0 : policy.name) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "danger",
    size: "s",
    className: "eui-displayInline"
  }, POLICY_IS_DELETED)) : agentPolicyId, canReadAgentPolicies && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\xA0 \xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: (policy === null || policy === void 0 ? void 0 : policy.agents) === 0 ? 'warning' : 'hollow'
  }, AGENTS_LABEL, policy === null || policy === void 0 ? void 0 : policy.agents)));
};
exports.PolicyName = PolicyName;
const POLICY_IS_DELETED = _i18n.i18n.translate('xpack.synthetics.monitorManagement.deletedPolicy', {
  defaultMessage: 'Policy is deleted'
});
const AGENTS_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.agents', {
  defaultMessage: 'Agents: '
});