"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatToIngestProcessors = formatToIngestProcessors;
var _streamsSchema = require("@kbn/streams-schema");
var _condition_to_painless = require("./condition_to_painless");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function formatToIngestProcessors(processing, {
  ignoreMalformedManualIngestPipeline
} = {}) {
  return processing.flatMap(processor => {
    const config = (0, _streamsSchema.getProcessorConfig)(processor);
    const type = (0, _streamsSchema.getProcessorType)(processor);
    if (type === 'manual_ingest_pipeline') {
      const manualIngestPipelineProcessorConfig = config;

      // manual_ingest_pipeline processor is a special case, since it has nested Elasticsearch-level processors and doesn't support if
      // directly - we need to add it to each nested processor
      return manualIngestPipelineProcessorConfig.processors.flatMap(nestedProcessor => {
        var _manualIngestPipeline, _nestedConfig$ignore_;
        const nestedType = Object.keys(nestedProcessor)[0];
        if (!_streamsSchema.elasticsearchProcessorTypes.includes(nestedType)) {
          if (ignoreMalformedManualIngestPipeline) {
            return [];
          }
          throw new Error(`Invalid processor type "${nestedType}" in manual_ingest_pipeline processor. Supported types: ${_streamsSchema.elasticsearchProcessorTypes.join(', ')}`);
        }
        const nestedConfig = nestedProcessor[nestedType];
        if (typeof nestedConfig !== 'object' || nestedConfig === null) {
          if (ignoreMalformedManualIngestPipeline) {
            return [];
          }
          throw new Error(`Invalid processor config for "${nestedType}" in manual_ingest_pipeline processor. Expected an object.`);
        }
        return {
          [nestedType]: {
            ...nestedConfig,
            tag: (_manualIngestPipeline = manualIngestPipelineProcessorConfig.tag) !== null && _manualIngestPipeline !== void 0 ? _manualIngestPipeline : nestedConfig.tag,
            ignore_failure: (_nestedConfig$ignore_ = nestedConfig.ignore_failure) !== null && _nestedConfig$ignore_ !== void 0 ? _nestedConfig$ignore_ : manualIngestPipelineProcessorConfig.ignore_failure,
            on_failure: nestedConfig.on_failure ? [...nestedConfig.on_failure, ...(manualIngestPipelineProcessorConfig.on_failure || [])] : manualIngestPipelineProcessorConfig.on_failure,
            ...(!nestedConfig.if && 'if' in config && config.if ? {
              if: (0, _condition_to_painless.conditionToPainless)(config.if)
            } : {})
          }
        };
      });
    }
    return [{
      [type]: {
        ...config,
        ...('if' in config && config.if ? {
          if: (0, _condition_to_painless.conditionToPainless)(config.if)
        } : {})
      }
    }];
  });
}