"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamStatsPanel = StreamStatsPanel;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _streamsSchema = require("@kbn/streams-schema");
var _ilm_link = require("../../data_management/stream_detail_lifecycle/ilm_link");
var _format_bytes = require("../../data_management/stream_detail_lifecycle/helpers/format_bytes");
var _use_data_stream_stats = require("../../data_management/stream_detail_lifecycle/hooks/use_data_stream_stats");
var _insufficient_privileges = require("../../insufficient_privileges/insufficient_privileges");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RetentionDisplay = ({
  definition
}) => {
  if (!definition) return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "-");
  if ((0, _streamsSchema.isDslLifecycle)(definition.effective_lifecycle)) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (definition === null || definition === void 0 ? void 0 : definition.effective_lifecycle.dsl.data_retention) || _i18n.i18n.translate('xpack.streams.entityDetailOverview.unlimited', {
      defaultMessage: 'Keep indefinitely'
    }));
  }
  if ((0, _streamsSchema.isIlmLifecycle)(definition.effective_lifecycle)) {
    return /*#__PURE__*/_react.default.createElement(_ilm_link.IlmLink, {
      lifecycle: definition.effective_lifecycle
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "-");
};
const StatItem = ({
  label,
  value,
  withBorder = false
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const borderStyle = withBorder ? (0, _css.css)`
        border-left: 1px solid ${euiTheme.colors.borderBaseSubdued};
        padding-left: ${euiTheme.size.s};
      ` : '';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    className: borderStyle
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, label), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m",
    className: (0, _css.css)`
            font-weight: bold;
          `
  }, value)));
};
function StreamStatsPanel({
  definition
}) {
  const dataStreamStats = (0, _use_data_stream_stats.useDataStreamStats)({
    definition
  }).stats;
  const retentionLabel = _i18n.i18n.translate('xpack.streams.entityDetailOverview.retention', {
    defaultMessage: 'Data retention'
  });
  const documentCountLabel = _i18n.i18n.translate('xpack.streams.entityDetailOverview.count', {
    defaultMessage: 'Document count'
  });
  const storageSizeLabel = _i18n.i18n.translate('xpack.streams.entityDetailOverview.size', {
    defaultMessage: 'Storage size'
  });
  const ingestionLabel = _i18n.i18n.translate('xpack.streams.entityDetailOverview.ingestion', {
    defaultMessage: 'Ingestion'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, retentionLabel), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement(RetentionDisplay, {
    definition: definition
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 9
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(StatItem, {
    label: documentCountLabel,
    value: /*#__PURE__*/_react.default.createElement(_insufficient_privileges.PrivilegesWarningIconWrapper, {
      hasPrivileges: definition.privileges.monitor,
      title: "totalDocCount"
    }, dataStreamStats ? (0, _eui.formatNumber)(dataStreamStats.totalDocs || 0, 'decimal0') : '-')
  }), /*#__PURE__*/_react.default.createElement(StatItem, {
    label: storageSizeLabel,
    value: /*#__PURE__*/_react.default.createElement(_insufficient_privileges.PrivilegesWarningIconWrapper, {
      hasPrivileges: definition.privileges.monitor,
      title: "sizeBytes"
    }, dataStreamStats && dataStreamStats.sizeBytes ? (0, _format_bytes.formatBytes)(dataStreamStats.sizeBytes) : '-'),
    withBorder: true
  }), /*#__PURE__*/_react.default.createElement(StatItem, {
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ingestionLabel, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.ingestionRateDetails', {
        defaultMessage: 'Approximate average (stream total size divided by the number of days since creation).'
      }),
      position: "right"
    })),
    value: /*#__PURE__*/_react.default.createElement(_insufficient_privileges.PrivilegesWarningIconWrapper, {
      hasPrivileges: definition.privileges.monitor,
      title: "ingestionRate"
    }, dataStreamStats ? (0, _format_bytes.formatIngestionRate)(dataStreamStats.bytesPerDay || 0, true) : '-'),
    withBorder: true
  })))));
}