"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RetentionMetadata = RetentionMetadata;
var _streamsSchema = require("@kbn/streams-schema");
var _react = _interopRequireDefault(require("react"));
var _reactHooks = require("@kbn/react-hooks");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _fieldTypes = require("@kbn/field-types");
var _react2 = require("@emotion/react");
var _use_kibana = require("../../../hooks/use_kibana");
var _ilm_link = require("./ilm_link");
var _use_streams_app_router = require("../../../hooks/use_streams_app_router");
var _format_bytes = require("./helpers/format_bytes");
var _insufficient_privileges = require("../../insufficient_privileges/insufficient_privileges");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function RetentionMetadata({
  definition,
  lifecycleActions,
  openEditModal,
  stats,
  isLoadingStats,
  statsError
}) {
  var _lifecycle$dsl$data_r;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const router = (0, _use_streams_app_router.useStreamsAppRouter)();
  const [isMenuOpen, {
    toggle: toggleMenu,
    off: closeMenu
  }] = (0, _reactHooks.useBoolean)(false);
  const dateFormatter = useDateFormatter();
  const lifecycle = definition.effective_lifecycle;
  const contextualMenu = lifecycleActions.length === 0 ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: !definition.privileges.lifecycle ? _i18n.i18n.translate('xpack.streams.entityDetailViewWithoutParams.editDataRetention.insufficientPrivileges', {
        defaultMessage: "You don't have sufficient privileges to change retention."
      }) : undefined
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "streamsAppRetentionMetadataEditDataRetentionButton",
      size: "s",
      onClick: toggleMenu,
      disabled: !definition.privileges.lifecycle,
      iconType: "pencil",
      css: (0, _react2.css)`
                margin-bottom: -${euiTheme.size.s};
              `
    }, _i18n.i18n.translate('xpack.streams.entityDetailViewWithoutParams.editDataRetention', {
      defaultMessage: 'Edit data retention'
    }))),
    isOpen: isMenuOpen,
    closePopover: closeMenu,
    panelPaddingSize: "none",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: lifecycleActions.map(({
      name,
      action
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: action,
      onClick: () => {
        closeMenu();
        openEditModal(action);
      }
    }, name))
  }));
  const ilmLink = (0, _streamsSchema.isIlmLifecycle)(lifecycle) ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow"
  }, /*#__PURE__*/_react.default.createElement(_ilm_link.IlmLink, {
    lifecycle: lifecycle
  })) : null;
  const lifecycleOrigin = (0, _streamsSchema.isInheritLifecycle)(definition.stream.ingest.lifecycle) ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.inheritedFrom', {
    defaultMessage: 'Inherited from'
  }), ' ', _streamsSchema.Streams.WiredStream.GetResponse.is(definition) ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "streamsAppRetentionMetadataLink",
    target: "_blank",
    href: router.link('/{key}/{tab}', {
      path: {
        key: definition.effective_lifecycle.from,
        tab: 'overview'
      }
    })
  }, "[", definition.effective_lifecycle.from, "]") : _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.localOverride', {
    defaultMessage: 'the underlying data stream'
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.localOverride', {
    defaultMessage: 'Local override'
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(MetadataRow, {
    metadata: _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.retentionPeriodLabel', {
      defaultMessage: 'Retention period'
    }),
    value: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      alignItems: "center",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: (0, _streamsSchema.isDisabledLifecycle)(lifecycle) ? 'default' : 'accent'
    }, (0, _streamsSchema.isDslLifecycle)(lifecycle) ? (_lifecycle$dsl$data_r = lifecycle.dsl.data_retention) !== null && _lifecycle$dsl$data_r !== void 0 ? _lifecycle$dsl$data_r : '∞' : (0, _streamsSchema.isIlmLifecycle)(lifecycle) ? _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.policyBased', {
      defaultMessage: 'Policy-based'
    }) : _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.policyDisabled', {
      defaultMessage: 'Disabled'
    }))), contextualMenu),
    dataTestSubj: "streamsAppRetentionMetadataRetentionPeriod"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }), /*#__PURE__*/_react.default.createElement(MetadataRow, {
    metadata: _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.retentionSourceLabel', {
      defaultMessage: 'Source'
    }),
    value: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      responsive: false
    }, ilmLink ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, ilmLink) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, lifecycleOrigin))
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }), /*#__PURE__*/_react.default.createElement(MetadataRow, {
    metadata: _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.lastUupdated', {
      defaultMessage: 'Last updated'
    }),
    value: /*#__PURE__*/_react.default.createElement(_insufficient_privileges.PrivilegesWarningIconWrapper, {
      hasPrivileges: definition.privileges.monitor,
      title: "lastUpdated"
    }, statsError ? '-' : isLoadingStats || !stats ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "s"
    }) : dateFormatter.convert(stats.lastActivity))
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }), /*#__PURE__*/_react.default.createElement(MetadataRow, {
    metadata: _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.ingestionRate', {
      defaultMessage: 'Ingestion'
    }),
    tip: _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.ingestionRateDetails', {
      defaultMessage: 'Approximate average (stream total size divided by the number of days since creation).'
    }),
    value: /*#__PURE__*/_react.default.createElement(_insufficient_privileges.PrivilegesWarningIconWrapper, {
      hasPrivileges: definition.privileges.monitor,
      title: "ingestionRate"
    }, statsError ? '-' : isLoadingStats || !stats ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "s"
    }) : stats.bytesPerDay ? (0, _format_bytes.formatIngestionRate)(stats.bytesPerDay) : '-')
  }));
}
function MetadataRow({
  metadata,
  value,
  tip,
  dataTestSubj
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xl",
    responsive: false,
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("b", null, metadata)), tip ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: tip,
    position: "right"
  })) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 5
  }, value));
}
const useDateFormatter = () => {
  const {
    fieldFormats
  } = (0, _use_kibana.useKibana)().dependencies.start;
  return fieldFormats.getDefaultInstance(_fieldTypes.KBN_FIELD_TYPES.DATE, [_fieldTypes.ES_FIELD_TYPES.DATE]);
};