"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SortableList = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SortableList = ({
  onDragItem,
  children
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDragDropContext, {
    onDragEnd: onDragItem
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDroppable, {
    droppableId: "droppable-area",
    css: (0, _react2.css)`
          background-color: ${euiTheme.colors.backgroundTransparent};
          margin-bottom: ${euiTheme.size.s};
        `
  }, children));
};
exports.SortableList = SortableList;