"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProcessorTypeSelector = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _reactHookForm = require("react-hook-form");
var _use_kibana = require("../../../../hooks/use_kibana");
var _utils = require("../utils");
var _config_driven = require("./config_driven");
var _stream_enrichment_state_machine = require("../state_management/stream_enrichment_state_machine");
var _selectors = require("../state_management/simulation_state_machine/selectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ProcessorTypeSelector = ({
  disabled = false
}) => {
  const {
    core
  } = (0, _use_kibana.useKibana)();
  const esDocUrl = core.docLinks.links.elasticsearch.docsBase;
  const getEnrichmentState = (0, _stream_enrichment_state_machine.useGetStreamEnrichmentState)();
  const {
    reset
  } = (0, _reactHookForm.useFormContext)();
  const {
    field,
    fieldState
  } = (0, _reactHookForm.useController)({
    name: 'type',
    rules: {
      required: true
    }
  });
  const processorType = (0, _reactHookForm.useWatch)({
    name: 'type'
  });
  const grokCollection = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(state => state.context.grokCollection);
  const handleChange = type => {
    var _getEnrichmentState$c;
    const formState = (0, _utils.getDefaultFormStateByType)(type, (0, _selectors.selectPreviewDocuments)((_getEnrichmentState$c = getEnrichmentState().context.simulatorRef) === null || _getEnrichmentState$c === void 0 ? void 0 : _getEnrichmentState$c.getSnapshot().context), {
      grokCollection
    });
    reset(formState);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.typeSelectorLabel', {
      defaultMessage: 'Processor'
    }),
    helpText: getProcessorDescription(esDocUrl)(processorType)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    disabled: disabled,
    options: processorTypeSelectorOptions,
    isInvalid: fieldState.invalid,
    valueOfSelected: field.value,
    onChange: handleChange,
    fullWidth: true,
    placeholder: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.typeSelectorPlaceholder', {
      defaultMessage: 'Grok, Dissect ...'
    })
  }));
};
exports.ProcessorTypeSelector = ProcessorTypeSelector;
const availableProcessors = {
  date: {
    type: 'date',
    inputDisplay: 'Date',
    getDocUrl: () => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.dateHelpText",
      defaultMessage: "Converts a date to a document timestamp."
    })
  },
  dissect: {
    type: 'dissect',
    inputDisplay: 'Dissect',
    getDocUrl: esDocUrl => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.dissectHelpText",
      defaultMessage: "Uses {dissectLink} patterns to extract matches from a field.",
      values: {
        dissectLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "streamsAppAvailableProcessorsDissectLink",
          external: true,
          target: "_blank",
          href: esDocUrl + 'dissect-processor.html'
        }, _i18n.i18n.translate('xpack.streams.availableProcessors.dissectLinkLabel', {
          defaultMessage: 'dissect'
        }))
      }
    })
  },
  grok: {
    type: 'grok',
    inputDisplay: 'Grok',
    getDocUrl: esDocUrl => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.grokHelpText",
      defaultMessage: "Uses {grokLink} expressions to extract matches from a field.",
      values: {
        grokLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "streamsAppAvailableProcessorsGrokLink",
          external: true,
          target: "_blank",
          href: esDocUrl + 'grok-processor.html'
        }, _i18n.i18n.translate('xpack.streams.availableProcessors.grokLinkLabel', {
          defaultMessage: 'grok'
        }))
      }
    })
  },
  ..._config_driven.configDrivenProcessors,
  manual_ingest_pipeline: {
    type: 'manual_ingest_pipeline',
    inputDisplay: 'Manual pipeline configuration',
    getDocUrl: () => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.manualIngestPipelineHelpText",
      defaultMessage: "Specify an array of ingest pipeline processors using JSON."
    })
  }
};
const getProcessorDescription = esDocUrl => type => availableProcessors[type].getDocUrl(esDocUrl);
const processorTypeSelectorOptions = Object.values(availableProcessors).map(({
  type,
  inputDisplay
}) => ({
  value: type,
  inputDisplay
}));