"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GrokPatternAISuggestions = void 0;
exports.GrokPatternSuggestion = GrokPatternSuggestion;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _grokUi = require("@kbn/grok-ui");
var _reactHookForm = require("react-hook-form");
var _use_stream_detail = require("../../../../../hooks/use_stream_detail");
var _selectors = require("../../state_management/simulation_state_machine/selectors");
var _stream_enrichment_state_machine = require("../../state_management/stream_enrichment_state_machine");
var _generate_pattern_button = require("./generate_pattern_button");
var _use_grok_pattern_suggestion = require("./use_grok_pattern_suggestion");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GrokPatternAISuggestions = ({
  aiFeatures,
  grokCollection,
  setValue,
  onAddPattern
}) => {
  const {
    definition: {
      stream
    }
  } = (0, _use_stream_detail.useStreamDetail)();
  const previewDocuments = (0, _stream_enrichment_state_machine.useSimulatorSelector)(snapshot => (0, _selectors.selectPreviewDocuments)(snapshot.context));
  const [suggestionsState, refreshSuggestions] = (0, _use_grok_pattern_suggestion.useGrokPatternSuggestion)();
  const fieldValue = (0, _reactHookForm.useWatch)({
    name: 'field'
  });
  const isValidField = (0, _react.useMemo)(() => {
    return Boolean(fieldValue && previewDocuments.some(sample => sample[fieldValue] && typeof sample[fieldValue] === 'string'));
  }, [previewDocuments, fieldValue]);
  if (suggestionsState.value && suggestionsState.value[0]) {
    return /*#__PURE__*/_react.default.createElement(GrokPatternSuggestion, {
      suggestion: suggestionsState.value[0],
      onAccept: () => {
        var _suggestionsState$val;
        const [suggestion] = (_suggestionsState$val = suggestionsState.value) !== null && _suggestionsState$val !== void 0 ? _suggestionsState$val : [];
        if (suggestion) {
          setValue('patterns', suggestion.grokProcessor.patterns.map(value => new _grokUi.DraftGrokExpression(grokCollection, value)));
          setValue('pattern_definitions', suggestion.grokProcessor.pattern_definitions);
        }
        refreshSuggestions(null);
      },
      onDismiss: () => refreshSuggestions(null)
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l",
    alignItems: "center"
  }, aiFeatures.enabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_generate_pattern_button.GeneratePatternButton, {
    aiFeatures: aiFeatures,
    onClick: connectorId => refreshSuggestions({
      connectorId,
      streamName: stream.name,
      samples: previewDocuments,
      fieldName: fieldValue
    }),
    isLoading: suggestionsState.loading,
    isDisabled: !isValidField
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "streamsAppGrokPatternsEditorAddPatternButton",
    flush: "left",
    size: "s",
    onClick: onAddPattern,
    isDisabled: suggestionsState.loading
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.grokEditor.addPattern', {
    defaultMessage: 'Add pattern'
  })))), aiFeatures && aiFeatures.isManagedAIConnector && !aiFeatures.hasAcknowledgedAdditionalCharges && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_generate_pattern_button.AdditionalChargesCallout, {
    aiFeatures: aiFeatures
  })));
};
exports.GrokPatternAISuggestions = GrokPatternAISuggestions;
function GrokPatternSuggestion({
  suggestion,
  onAccept,
  onDismiss
}) {
  const processorMetrics = suggestion.simulationResult.processors_metrics['grok-processor'];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "sparkles",
    title: suggestion.description,
    color: "primary",
    size: "s",
    onDismiss: onDismiss
  }, suggestion.grokProcessor.patterns.map((pattern, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    key: pattern,
    paddingSize: "none",
    language: "regex",
    transparentBackground: true
  }, pattern)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    responsive: false,
    wrap: false,
    alignItems: "flexStart",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadgeGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow"
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.grokPatternSuggestion.matchRateBadge', {
    defaultMessage: '{percentage}% Matched',
    values: {
      percentage: (processorMetrics.parsed_rate * 100).toFixed()
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow"
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.grokPatternSuggestion.fieldCountBadge', {
    defaultMessage: '{count} Fields',
    values: {
      count: processorMetrics.detected_fields.length
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "check",
    onClick: onAccept,
    color: "primary",
    size: "s"
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.grokPatternSuggestion.acceptButton', {
    defaultMessage: 'Accept'
  })))));
}