"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterGroup = void 0;
var _eui = require("@elastic/eui");
var _reactHooks = require("@kbn/react-hooks");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FilterGroup = ({
  filterGroupButtonLabel,
  items,
  onChange
}) => {
  const [isPopoverOpen, {
    off: closePopover,
    toggle
  }] = (0, _reactHooks.useBoolean)(false);
  const filterGroupPopoverId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'filterGroupPopover'
  });
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    iconType: "arrowDown",
    badgeColor: "success",
    onClick: toggle,
    isSelected: isPopoverOpen,
    numFilters: items.length,
    hasActiveFilters: !!items.find(item => item.checked === 'on'),
    numActiveFilters: items.filter(item => item.checked === 'on').length
  }, filterGroupButtonLabel);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: filterGroupPopoverId,
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "aria-label": filterGroupButtonLabel,
    options: items,
    onChange: onChange
  }, list => /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
                min-width: 220px;
              `
  }, list))));
};
exports.FilterGroup = FilterGroup;