"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PreviewTable = PreviewTable;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _utils = require("../stream_detail_enrichment/utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function PreviewTable({
  documents,
  displayColumns,
  height,
  renderCellValue,
  rowHeightsOptions,
  sorting,
  setSorting,
  toolbarVisibility = false,
  setVisibleColumns,
  columnOrderHint = []
}) {
  // Determine canonical column order
  const canonicalColumnOrder = (0, _react.useMemo)(() => {
    const cols = new Set();
    documents.forEach(doc => {
      if (!doc || typeof doc !== 'object') {
        return;
      }
      Object.keys(doc).forEach(key => {
        cols.add(key);
      });
    });
    let allColumns = Array.from(cols);

    // Sort columns by displayColumns or alphabetically as baseline
    allColumns = allColumns.sort((a, b) => {
      const indexA = (displayColumns || []).indexOf(a);
      const indexB = (displayColumns || []).indexOf(b);
      if (indexA === -1 && indexB === -1) {
        return a.localeCompare(b);
      }
      if (indexA === -1) return 1;
      if (indexB === -1) return -1;
      return indexA - indexB;
    });

    // Sort columns based on the columnOrderHint if provided
    if (columnOrderHint.length > 0) {
      const orderedCols = columnOrderHint.filter(col => allColumns.includes(col));
      const unorderedCols = allColumns.filter(col => !orderedCols.includes(col));
      allColumns = [...orderedCols, ...unorderedCols];
    }
    // Always show the displayColumns first, but preserve the order from allColumns
    if (displayColumns) {
      const displaySet = new Set(displayColumns);
      allColumns = [...allColumns.filter(col => displaySet.has(col)), ...allColumns.filter(col => !displaySet.has(col))];
    }
    return allColumns;
  }, [columnOrderHint, displayColumns, documents]);
  const sortingConfig = (0, _react.useMemo)(() => {
    if (!sorting && !setSorting) {
      return undefined;
    }
    return {
      columns: sorting !== null && sorting !== void 0 && sorting.fieldName ? [{
        id: (sorting === null || sorting === void 0 ? void 0 : sorting.fieldName) || '',
        direction: (sorting === null || sorting === void 0 ? void 0 : sorting.direction) || 'asc'
      }] : [],
      onSort: newSorting => {
        if (setSorting) {
          const mostRecentSorting = newSorting[newSorting.length - 1];
          setSorting({
            fieldName: mostRecentSorting === null || mostRecentSorting === void 0 ? void 0 : mostRecentSorting.id,
            direction: (mostRecentSorting === null || mostRecentSorting === void 0 ? void 0 : mostRecentSorting.direction) || 'asc'
          });
        }
      }
    };
  }, [setSorting, sorting]);
  const [columnWidths, setColumnWidths] = (0, _react.useState)({});

  // Derive visibleColumns from canonical order
  const visibleColumns = (0, _react.useMemo)(() => {
    if (displayColumns) {
      return canonicalColumnOrder.filter(col => displayColumns.includes(col));
    }
    return canonicalColumnOrder;
  }, [canonicalColumnOrder, displayColumns]);
  const onColumnResize = (0, _react.useCallback)(({
    columnId,
    width
  }) => {
    setColumnWidths(prev => {
      const updated = (0, _utils.recalcColumnWidths)({
        columnId,
        width,
        prevWidths: prev,
        visibleColumns
      });
      return updated;
    });
  }, [visibleColumns]);
  const gridColumns = (0, _react.useMemo)(() => {
    return canonicalColumnOrder.map(column => ({
      id: column,
      displayAsText: column,
      actions: Boolean(setVisibleColumns) || Boolean(setSorting) ? {
        showHide: Boolean(setVisibleColumns),
        showMoveLeft: Boolean(setVisibleColumns),
        showMoveRight: Boolean(setVisibleColumns),
        showSortAsc: Boolean(setSorting),
        showSortDesc: Boolean(setSorting)
      } : false,
      initialWidth: columnWidths[column]
    }));
  }, [canonicalColumnOrder, setSorting, setVisibleColumns, columnWidths]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDataGrid, {
    "aria-label": _i18n.i18n.translate('xpack.streams.resultPanel.euiDataGrid.previewLabel', {
      defaultMessage: 'Preview'
    }),
    columns: gridColumns,
    columnVisibility: {
      visibleColumns,
      setVisibleColumns: setVisibleColumns || (() => {}),
      canDragAndDropColumns: false
    },
    sorting: sortingConfig,
    inMemory: sortingConfig ? {
      level: 'sorting'
    } : undefined,
    height: height,
    toolbarVisibility: toolbarVisibility,
    rowCount: documents.length,
    rowHeightsOptions: rowHeightsOptions,
    onColumnResize: onColumnResize,
    renderCellValue: ({
      rowIndex,
      columnId
    }) => {
      const doc = documents[rowIndex];
      if (!doc || typeof doc !== 'object') {
        return '';
      }
      if (renderCellValue) {
        const renderedValue = renderCellValue(doc, columnId);
        if (renderedValue !== undefined) {
          return renderedValue;
        }
      }
      const value = doc[columnId];
      if (value === undefined || value === null) {
        return '';
      }
      if (typeof value === 'object') {
        return JSON.stringify(value);
      }
      return String(value);
    }
  });
}