"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToggleAllFeatures = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
require("./toggle_all_features.scss");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const options = [{
  id: 'show',
  text: _i18n.i18n.translate('xpack.spaces.management.showAllFeaturesText', {
    defaultMessage: 'Show all'
  })
}, {
  id: 'hide',
  text: _i18n.i18n.translate('xpack.spaces.management.hideAllFeaturesText', {
    defaultMessage: 'Hide all'
  })
}];
class ToggleAllFeatures extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isPopoverOpen: false
    });
    (0, _defineProperty2.default)(this, "onSelect", selection => {
      this.props.onChange(selection === 'show');
      this.setState({
        isPopoverOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "onButtonClick", () => {
      this.setState({
        isPopoverOpen: !this.state.isPopoverOpen
      });
    });
    (0, _defineProperty2.default)(this, "closePopover", () => {
      this.setState({
        isPopoverOpen: false
      });
    });
  }
  render() {
    const button = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: this.onButtonClick,
      className: 'spcToggleAllFeatures__changeAllLink'
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.management.toggleAllFeaturesLink",
      defaultMessage: "(change all)"
    }));
    const items = options.map(item => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        "data-test-subj": `spc-toggle-all-features-${item.id}`,
        key: item.id,
        onClick: () => {
          this.onSelect(item.id);
        },
        disabled: this.props.disabled
      }, item.text);
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      button: button,
      "data-test-subj": "changeAllFeatureVisibilityPopover",
      isOpen: this.state.isPopoverOpen,
      closePopover: this.closePopover,
      panelPaddingSize: "none",
      anchorPosition: "downLeft"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
      items: items
    }));
  }
}
exports.ToggleAllFeatures = ToggleAllFeatures;