"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SnapshotDetails = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _shared_imports = require("../../../../../shared_imports");
var _components = require("../../../../components");
var _app_context = require("../../../../app_context");
var _constants = require("../../../../constants");
var _http = require("../../../../services/http");
var _navigation = require("../../../../services/navigation");
var _tabs = require("./tabs");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TAB_SUMMARY = 'summary';
const TAB_FAILURES = 'failures';
const panelTypeToUiMetricMap = {
  [TAB_SUMMARY]: _constants.UIM_SNAPSHOT_DETAIL_PANEL_SUMMARY_TAB,
  [TAB_FAILURES]: _constants.UIM_SNAPSHOT_DETAIL_PANEL_FAILED_INDICES_TAB
};
const SnapshotDetails = ({
  repositoryName,
  snapshotId,
  onClose,
  onSnapshotDeleted
}) => {
  const {
    i18n,
    uiMetricService,
    history
  } = (0, _app_context.useServices)();
  const {
    error,
    data: snapshotDetails
  } = (0, _http.useLoadSnapshot)(repositoryName, snapshotId);
  const [activeTab, setActiveTab] = (0, _react.useState)(TAB_SUMMARY);

  // Reset tab when we look at a different snapshot.
  (0, _react.useEffect)(() => {
    setActiveTab(TAB_SUMMARY);
  }, [repositoryName, snapshotId]);
  let tabs;
  let content;
  if (snapshotDetails) {
    const {
      indexFailures,
      state: snapshotState
    } = snapshotDetails;
    const tabOptions = [{
      id: TAB_SUMMARY,
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.snapshotDetails.summaryTabTitle",
        defaultMessage: "Summary"
      })
    }, {
      id: TAB_FAILURES,
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.snapshotDetails.failuresTabTitle",
        defaultMessage: "Failed indices ({failuresCount})",
        values: {
          failuresCount: indexFailures.length
        }
      })
    }];
    tabs = /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, null, tabOptions.map(tab => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      onClick: () => {
        uiMetricService.trackUiMetric(panelTypeToUiMetricMap[tab.id]);
        setActiveTab(tab.id);
      },
      isSelected: tab.id === activeTab,
      key: tab.id,
      "data-test-subj": "tab"
    }, tab.name))));
    if (activeTab === TAB_SUMMARY) {
      content = /*#__PURE__*/_react.default.createElement(_tabs.TabSummary, {
        snapshotDetails: snapshotDetails
      });
    } else if (activeTab === TAB_FAILURES) {
      content = /*#__PURE__*/_react.default.createElement(_tabs.TabFailures, {
        snapshotState: snapshotState,
        indexFailures: indexFailures
      });
    }
  } else if (error) {
    const notFound = error.status === 404;
    const errorObject = notFound ? {
      data: {
        error: i18n.translate('xpack.snapshotRestore.snapshotDetails.errorSnapshotNotFound', {
          defaultMessage: `Either the snapshot ''{snapshotId}'' doesn't exist in the repository ''{repositoryName}'' or the repository doesn't exist.`,
          values: {
            snapshotId,
            repositoryName
          }
        })
      }
    } : error;
    content = /*#__PURE__*/_react.default.createElement(_shared_imports.SectionError, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.snapshotDetails.errorLoadingRepositoryTitle",
        defaultMessage: "Error loading repository"
      }),
      error: errorObject
    });
  } else {
    // Assume the content is loading.
    content = /*#__PURE__*/_react.default.createElement(_components.SectionLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.snapshotDetails.loadingSnapshotDescription",
      defaultMessage: "Loading snapshot\u2026"
    }));
  }
  const renderFooter = () => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      iconType: "cross",
      flush: "left",
      onClick: onClose,
      "data-test-subj": "closeButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.snapshotDetails.closeButtonLabel",
      defaultMessage: "Close"
    }))), snapshotDetails ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_components.SnapshotDeleteProvider, null, deleteSnapshotPrompt => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        color: "danger",
        "data-test-subj": "srSnapshotDetailsDeleteActionButton",
        onClick: () => deleteSnapshotPrompt([{
          repository: repositoryName,
          snapshot: snapshotId
        }], onSnapshotDeleted),
        isDisabled: snapshotDetails.managedRepository && snapshotDetails.isLastSuccessfulSnapshot,
        title: snapshotDetails.managedRepository && snapshotDetails.isLastSuccessfulSnapshot ? i18n.translate('xpack.snapshotRestore.snapshotDetails.deleteManagedRepositorySnapshotButtonTitle', {
          defaultMessage: 'You cannot delete the last successful snapshot stored in a managed repository.'
        }) : undefined
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.snapshotDetails.deleteButtonLabel",
        defaultMessage: "Delete"
      }));
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, (0, _public.reactRouterNavigate)(history, (0, _navigation.linkToRestoreSnapshot)(repositoryName, snapshotId)), {
      fill: true,
      color: "primary",
      isDisabled: snapshotDetails.state !== _constants.SNAPSHOT_STATE.SUCCESS && snapshotDetails.state !== _constants.SNAPSHOT_STATE.PARTIAL,
      "data-test-subj": "restoreSnapshotButton"
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.snapshotDetails.restoreButtonLabel",
      defaultMessage: "Restore"
    }))))) : null);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    "data-test-subj": "snapshotDetail",
    "aria-labelledby": "srSnapshotDetailsFlyoutTitle",
    size: "m",
    maxWidth: 550
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h2", {
    id: "srSnapshotDetailsFlyoutTitle",
    "data-test-subj": "detailTitle"
  }, snapshotId), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement("small", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({}, (0, _public.reactRouterNavigate)(history, (0, _navigation.linkToRepository)(repositoryName)), {
    "data-test-subj": "repositoryLink"
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.snapshotDetails.repositoryTitle",
    defaultMessage: "''{repositoryName}'' repository",
    values: {
      repositoryName
    }
  }))))), tabs), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    "data-test-subj": "content"
  }, content), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, renderFooter()));
};
exports.SnapshotDetails = SnapshotDetails;