"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HDFSSettings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _codeEditor = require("@kbn/code-editor");
var _common = require("./common");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HDFSSettings = ({
  repository,
  updateRepositorySettings,
  settingErrors
}) => {
  const {
    name,
    settings: {
      delegateType,
      uri,
      path,
      loadDefaults,
      compress,
      chunkSize,
      maxRestoreBytesPerSec,
      maxSnapshotBytesPerSec,
      readonly,
      'security.principal': securityPrincipal,
      ...rest // For conf.* settings
    }
  } = repository;
  const hasErrors = Boolean(Object.keys(settingErrors).length);
  const updateSettings = (settingName, value) => {
    updateRepositorySettings({
      [settingName]: value
    });
  };
  const [additionalConf, setAdditionalConf] = (0, _react.useState)(JSON.stringify(rest, null, 2));
  const [isConfInvalid, setIsConfInvalid] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeHDFS.uriTitle",
      defaultMessage: "URI"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeHDFS.uriDescription",
      defaultMessage: "The URI address for HDFS."
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeHDFS.uriLabel",
      defaultMessage: "URI (required)"
    }),
    fullWidth: true,
    isInvalid: Boolean(hasErrors && settingErrors.uri),
    error: settingErrors.uri
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      id: "hdfsRepositoryUriProtocolDescription"
    }, 'hdfs://'),
    defaultValue: uri ? uri.split('hdfs://')[1] : '',
    fullWidth: true,
    onChange: e => {
      updateRepositorySettings({
        uri: e.target.value ? `hdfs://${e.target.value}` : ''
      });
    },
    "aria-describedby": "hdfsRepositoryUriProtocolDescription",
    "data-test-subj": "uriInput"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeHDFS.pathTitle",
      defaultMessage: "Path"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeHDFS.pathDescription",
      defaultMessage: "The file path where data is stored."
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeHDFS.pathLabel",
      defaultMessage: "Path (required)"
    }),
    fullWidth: true,
    isInvalid: Boolean(hasErrors && settingErrors.path),
    error: settingErrors.path
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    defaultValue: path || '',
    fullWidth: true,
    onChange: e => {
      updateRepositorySettings({
        path: e.target.value
      });
    },
    "data-test-subj": "pathInput"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeHDFS.loadDefaultsTitle",
      defaultMessage: "Load defaults"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeHDFS.loadDefaultsDescription",
      defaultMessage: "Loads the default Hadoop configuration."
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    isInvalid: Boolean(hasErrors && settingErrors.loadDefaults),
    error: settingErrors.loadDefaults
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeHDFS.loadDefaultsLabel",
      defaultMessage: "Load defaults"
    }),
    checked: !(loadDefaults === false),
    onChange: e => {
      updateRepositorySettings({
        loadDefaults: e.target.checked
      });
    },
    "data-test-subj": "loadDefaultsToggle"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeHDFS.compressTitle",
      defaultMessage: "Snapshot compression"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeHDFS.compressDescription",
      defaultMessage: "Compresses the index mapping and setting files for snapshots. Data files are not compressed."
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    isInvalid: Boolean(hasErrors && settingErrors.compress),
    error: settingErrors.compress
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeHDFS.compressLabel",
      defaultMessage: "Compress snapshots"
    }),
    checked: !(compress === false),
    onChange: e => {
      updateRepositorySettings({
        compress: e.target.checked
      });
    },
    "data-test-subj": "compressToggle"
  }))), /*#__PURE__*/_react.default.createElement(_common.ChunkSizeField, {
    isInvalid: Boolean(hasErrors && settingErrors.chunkSize),
    error: settingErrors.chunkSize,
    defaultValue: chunkSize || '',
    updateSettings: updateSettings
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeHDFS.securityPrincipalTitle",
      defaultMessage: "Security principal"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeHDFS.securityPrincipalDescription",
      defaultMessage: "The Kerberos principal to use when connecting to a secured HDFS cluster."
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeHDFS.securityPrincipalLabel",
      defaultMessage: "Security principal"
    }),
    fullWidth: true,
    isInvalid: Boolean(hasErrors && settingErrors.securityPrincipal),
    error: settingErrors.securityPrincipal
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    defaultValue: securityPrincipal || '',
    fullWidth: true,
    onChange: e => {
      updateRepositorySettings({
        'security.principal': e.target.value
      });
    },
    "data-test-subj": "securityPrincipalInput"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeHDFS.configurationTitle",
      defaultMessage: "Configuration"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeHDFS.configurationDescription",
      defaultMessage: "Additional JSON format configuration parameters to add to the Hadoop configuration. Only client-oriented properties from the Hadoop core and HDFS files are recognized."
    })),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeHDFS.configurationLabel",
      defaultMessage: "Configuration"
    }),
    fullWidth: true,
    isInvalid: isConfInvalid,
    error: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeHDFS.configurationFormatError",
      defaultMessage: "Invalid JSON format"
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeHDFS.configurationKeyDescription",
      defaultMessage: "Keys should be in the format {confKeyFormat}.",
      values: {
        confKeyFormat: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'conf.<key>')
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    languageId: "json",
    value: additionalConf,
    "data-test-subj": "codeEditor",
    height: 250,
    options: {
      lineNumbers: 'off',
      tabSize: 2,
      automaticLayout: true
    },
    "aria-label": _i18n.i18n.translate('xpack.snapshotRestore.repositoryForm.typeHDFS.configurationAriaLabel', {
      defaultMessage: `Additional configuration for HDFS repository ''{name}''`,
      values: {
        name
      }
    }),
    onChange: value => {
      setAdditionalConf(value);
      try {
        const parsedConf = JSON.parse(value);
        setIsConfInvalid(false);
        updateRepositorySettings({
          delegateType,
          uri,
          path,
          loadDefaults,
          compress,
          chunkSize,
          'security.principal': securityPrincipal,
          ...parsedConf
        }, true);
      } catch (e) {
        setIsConfInvalid(true);
      }
    }
  }))), /*#__PURE__*/_react.default.createElement(_common.MaxSnapshotsField, {
    isInvalid: Boolean(hasErrors && settingErrors.maxSnapshotBytesPerSec),
    error: settingErrors.maxSnapshotBytesPerSec,
    defaultValue: maxSnapshotBytesPerSec || '',
    updateSettings: updateSettings
  }), /*#__PURE__*/_react.default.createElement(_common.MaxRestoreField, {
    isInvalid: Boolean(hasErrors && settingErrors.maxRestoreBytesPerSec),
    error: settingErrors.maxRestoreBytesPerSec,
    defaultValue: maxRestoreBytesPerSec || '',
    updateSettings: updateSettings
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeHDFS.readonlyTitle",
      defaultMessage: "Read-only"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeHDFS.readonlyDescription",
      defaultMessage: "Only one cluster should have write access to this repository. All other clusters should be read-only."
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    isInvalid: Boolean(hasErrors && settingErrors.readonly),
    error: settingErrors.readonly
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeHDFS.readonlyLabel",
      defaultMessage: "Read-only repository"
    }),
    checked: !!readonly,
    onChange: e => {
      updateRepositorySettings({
        readonly: e.target.checked
      });
    },
    "data-test-subj": "readOnlyToggle"
  }))));
};
exports.HDFSSettings = HDFSSettings;