"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RepositoryFormStepTwo = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../../../../common/constants");
var _type_settings = require("./type_settings");
var _text = require("../../services/text");
var _app_context = require("../../app_context");
var _type_to_doc_url = require("../../lib/type_to_doc_url");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RepositoryFormStepTwo = ({
  repository,
  isManagedRepository,
  isEditing,
  isSaving,
  onSave,
  updateRepository,
  validation,
  saveError,
  onBack
}) => {
  const {
    docLinks
  } = (0, _app_context.useCore)();
  const hasValidationErrors = !validation.isValid;
  const {
    name,
    type,
    settings: {
      delegateType
    }
  } = repository;
  const typeForDocs = type === _constants.REPOSITORY_TYPES.source ? delegateType : type;
  const renderSettings = () => /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    "data-test-subj": "title"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.repositoryForm.fields.settingsTitle",
    defaultMessage: "{repositoryName} settings",
    values: {
      repositoryName: `'${name}'`
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    flush: "right",
    href: (0, _type_to_doc_url.getRepositoryTypeDocUrl)(docLinks, typeForDocs),
    target: "_blank",
    iconType: "question"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.repositoryForm.repositoryTypeDocLink",
    defaultMessage: "{repositoryType} repository docs",
    values: {
      repositoryType: _text.textService.getRepositoryTypeName(typeForDocs)
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_type_settings.TypeSettings, {
    repository: repository,
    isManagedRepository: isManagedRepository,
    updateRepository: updateRepository,
    settingErrors: hasValidationErrors && validation.errors.settings ? validation.errors.settings : {}
  }));
  const renderActions = () => {
    const saveLabel = isEditing ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.saveButtonLabel",
      defaultMessage: "Save"
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.registerButtonLabel",
      defaultMessage: "Register"
    });
    const savingLabel = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.savingButtonLabel",
      defaultMessage: "Saving\u2026"
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "m",
      alignItems: "center"
    }, isEditing ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      color: "primary",
      iconType: "arrowLeft",
      onClick: onBack,
      "data-test-subj": "backButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.backButtonLabel",
      defaultMessage: "Back"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: isManagedRepository ? 'warning' : 'success',
      iconType: "check",
      onClick: onSave,
      fill: isManagedRepository ? false : true,
      "data-test-subj": "submitButton",
      isLoading: isSaving
    }, isSaving ? savingLabel : saveLabel)));
  };
  const renderFormValidationError = () => {
    if (!hasValidationErrors) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.repositoryForm.validationErrorTitle",
        defaultMessage: "Fix errors before continuing."
      }),
      role: "alert",
      color: "danger",
      iconType: "cross",
      "data-test-subj": "repositoryFormError"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }));
  };
  const renderSaveError = () => {
    if (!saveError) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, saveError, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }));
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "stepTwo"
  }, renderSettings(), renderFormValidationError(), renderSaveError(), renderActions());
};
exports.RepositoryFormStepTwo = RepositoryFormStepTwo;