"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyStepSettings = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _fields = require("./fields");
var _app_context = require("../../../../app_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PolicyStepSettings = ({
  policy,
  indices,
  dataStreams,
  updatePolicy,
  errors
}) => {
  const {
    docLinks
  } = (0, _app_context.useCore)();
  const {
    config = {},
    isManagedPolicy
  } = policy;
  const updatePolicyConfig = (updatedFields, validationHelperData = {}) => {
    const newConfig = {
      ...config,
      ...updatedFields
    };
    updatePolicy({
      config: newConfig
    }, validationHelperData);
  };
  const renderIgnoreUnavailableField = () => /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepSettings.ignoreUnavailableDescriptionTitle",
      defaultMessage: "Ignore unavailable indices"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepSettings.ignoreUnavailableDescription",
      defaultMessage: "Ignores indices that are unavailable when taking the snapshot. Otherwise, the entire snapshot will fail."
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": "ignoreUnavailableIndicesToggle",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepSettings.ignoreUnavailableLabel",
      defaultMessage: "Ignore unavailable indices"
    }),
    checked: Boolean(config.ignoreUnavailable),
    onChange: e => {
      updatePolicyConfig({
        ignoreUnavailable: e.target.checked
      });
    }
  })));
  const renderPartialField = () => /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepSettings.partialDescriptionTitle",
      defaultMessage: "Allow partial indices"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepSettings.partialDescription",
      defaultMessage: "Allows snapshots of indices with primary shards that are unavailable. Otherwise, the entire snapshot will fail."
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": "partialIndicesToggle",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepSettings.partialIndicesToggleSwitch",
      defaultMessage: "Allow partial indices"
    }),
    checked: Boolean(config.partial),
    onChange: e => {
      updatePolicyConfig({
        partial: e.target.checked
      });
    }
  })));
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "snapshotRestore__policyForm__stepSettings"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyForm.stepSettingsTitle",
    defaultMessage: "Snapshot settings"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    flush: "right",
    href: docLinks.links.snapshotRestore.createSnapshot,
    target: "_blank",
    iconType: "question"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyForm.stepSettings.docsButtonLabel",
    defaultMessage: "Snapshot docs"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_fields.IndicesAndDataStreamsField, {
    isManagedPolicy: isManagedPolicy,
    errors: errors,
    dataStreams: dataStreams,
    indices: indices,
    policy: policy,
    onUpdate: updatePolicyConfig
  }), renderIgnoreUnavailableField(), renderPartialField(), /*#__PURE__*/_react.default.createElement(_fields.IncludeGlobalStateField, {
    errors: errors,
    policy: policy,
    onUpdate: updatePolicyConfig
  }), /*#__PURE__*/_react.default.createElement(_fields.IncludeFeatureStatesField, {
    errors: errors,
    policy: policy,
    onUpdate: updatePolicyConfig
  }));
};
exports.PolicyStepSettings = PolicyStepSettings;