"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloStateBadge = SloStateBadge;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloStateBadge({
  slo
}) {
  const isEnabled = slo.enabled;
  if (isEnabled) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: _i18n.i18n.translate('xpack.slo.sloStateBadge.disabled.tooltip', {
      defaultMessage: 'This SLO is disabled. Enable it to start processing data.'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "default"
  }, _i18n.i18n.translate('xpack.slo.sloStateBadge.disabled.label', {
    defaultMessage: 'Disabled'
  }))));
}