"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStyles = void 0;
var _react = require("react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStyles = ({
  display
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const cached = (0, _react.useMemo)(() => {
    const item = {
      display,
      alignContent: 'center',
      padding: `${euiTheme.size.xs} ${euiTheme.size.s} `,
      width: '100%',
      fontWeight: 'inherit',
      height: 'max-content',
      minHeight: euiTheme.size.l,
      letterSpacing: '0px',
      textAlign: 'left',
      '& .euiToolTipAnchor': {
        width: `calc(100% - ${euiTheme.size.xl})`,
        whiteSpace: 'nowrap',
        overflow: 'hidden',
        textOverflow: 'ellipsis'
      }
    };
    const copiableItem = {
      ...item,
      position: 'relative',
      borderRadius: euiTheme.border.radius.medium,
      '&:hover': {
        background: (0, _eui.transparentize)(euiTheme.colors.primary, 0.1)
      },
      height: 'fit-content'
    };
    return {
      item,
      copiableItem
    };
  }, [display, euiTheme]);
  return cached;
};
exports.useStyles = useStyles;