"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ImportListItemsResponse = exports.ImportListItemsRequestQuery = void 0;
var _zod = require("@kbn/zod");
var _list_common = require("../model/list_common.gen");
var _list_schemas = require("../model/list_schemas.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Import list items API endpoint
 *   version: 2023-10-31
 */

const ImportListItemsRequestQuery = exports.ImportListItemsRequestQuery = _zod.z.object({
  /** 
      * List's id.
  Required when importing to an existing list.
        */
  list_id: _list_common.ListId.optional(),
  /** 
      * Type of the importing list.
  Required when importing a new list that is `list_id` is not specified.
        */
  type: _list_common.ListType.optional(),
  serializer: _zod.z.string().optional(),
  deserializer: _zod.z.string().optional(),
  /**
   * Determines when changes made by the request are made visible to search
   */
  refresh: _zod.z.enum(['true', 'false', 'wait_for']).optional()
});
const ImportListItemsResponse = exports.ImportListItemsResponse = _list_schemas.List;