"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.THRESHOLD_MINUTES = exports.METERING_CONFIGS = exports.KSPM = exports.CSPM = exports.CNVM = exports.CLOUD_SECURITY_TASK_TYPE = exports.CLOUD_DEFEND_HEARTBEAT_INDEX = exports.CLOUD_DEFEND = exports.BILLABLE_ASSETS_CONFIG = exports.ASSETS_SAMPLE_GRANULARITY = exports.AGGREGATION_PRECISION_THRESHOLD = void 0;
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _constants = require("@kbn/cloud-security-posture-plugin/common/constants");
var _constants2 = require("@kbn/cloud-defend-plugin/common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CLOUD_DEFEND_HEARTBEAT_INDEX = exports.CLOUD_DEFEND_HEARTBEAT_INDEX = 'metrics-cloud_defend.heartbeat-*';
const CLOUD_SECURITY_TASK_TYPE = exports.CLOUD_SECURITY_TASK_TYPE = 'cloud_security';
const AGGREGATION_PRECISION_THRESHOLD = exports.AGGREGATION_PRECISION_THRESHOLD = 40000;
const ASSETS_SAMPLE_GRANULARITY = exports.ASSETS_SAMPLE_GRANULARITY = '24h';
const THRESHOLD_MINUTES = exports.THRESHOLD_MINUTES = 30;
const CSPM = exports.CSPM = _cloudSecurityPostureCommon.CSPM_POLICY_TEMPLATE;
const KSPM = exports.KSPM = _cloudSecurityPostureCommon.KSPM_POLICY_TEMPLATE;
const CNVM = exports.CNVM = _constants.CNVM_POLICY_TEMPLATE;
const CLOUD_DEFEND = exports.CLOUD_DEFEND = _constants2.INTEGRATION_PACKAGE_NAME;
const METERING_CONFIGS = exports.METERING_CONFIGS = {
  [CSPM]: {
    index: _cloudSecurityPostureCommon.CDR_LATEST_NATIVE_MISCONFIGURATIONS_INDEX_PATTERN,
    assets_identifier: 'resource.id'
  },
  [KSPM]: {
    index: _cloudSecurityPostureCommon.CDR_LATEST_NATIVE_MISCONFIGURATIONS_INDEX_PATTERN,
    assets_identifier: 'agent.id'
  },
  [CNVM]: {
    index: _cloudSecurityPostureCommon.CDR_LATEST_NATIVE_VULNERABILITIES_INDEX_PATTERN,
    assets_identifier: 'cloud.instance.id'
  },
  [CLOUD_DEFEND]: {
    index: CLOUD_DEFEND_HEARTBEAT_INDEX,
    assets_identifier: 'agent.id'
  }
};

// see https://github.com/elastic/security-team/issues/8970 for billable asset definition
const BILLABLE_ASSETS_CONFIG = exports.BILLABLE_ASSETS_CONFIG = {
  [CSPM]: {
    filter_attribute: 'resource.sub_type',
    values: [
    // 'aws-ebs', we can't include EBS volumes until https://github.com/elastic/security-team/issues/9283 is resolved
    // 'aws-ec2', we can't include EC2 instances until https://github.com/elastic/security-team/issues/9254 is resolved
    'aws-s3', 'aws-rds', 'azure-disk', 'azure-document-db-database-account', 'azure-flexible-mysql-server-db', 'azure-flexible-postgresql-server-db', 'azure-mysql-server-db', 'azure-postgresql-server-db', 'azure-sql-server', 'azure-storage-account', 'azure-vm', 'gcp-bigquery-dataset', 'gcp-compute-disk', 'gcp-compute-instance', 'gcp-sqladmin-instance', 'gcp-storage-bucket']
  },
  [KSPM]: {
    filter_attribute: 'resource.sub_type',
    values: ['Node', 'node']
  }
};