"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleMigrationsDataService = exports.INDEX_PATTERN = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _indexAdapter = require("@kbn/index-adapter");
var _rule_migrations_data_client = require("./rule_migrations_data_client");
var _rule_migrations_field_maps = require("./rule_migrations_field_maps");
var _index_migrators = require("../index_migrators");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TOTAL_FIELDS_LIMIT = 2500;
const INDEX_PATTERN = exports.INDEX_PATTERN = '.kibana-siem-rule-migrations';
class RuleMigrationsDataService {
  constructor(logger, kibanaVersion, elserInferenceId) {
    (0, _defineProperty2.default)(this, "adapters", void 0);
    this.logger = logger;
    this.kibanaVersion = kibanaVersion;
    this.adapters = {
      migrations: this.createIndexPatternAdapter({
        adapterId: 'migrations',
        fieldMap: _rule_migrations_field_maps.migrationsFieldMaps
      }),
      rules: this.createIndexPatternAdapter({
        adapterId: 'rules',
        fieldMap: _rule_migrations_field_maps.ruleMigrationsFieldMap
      }),
      resources: this.createIndexPatternAdapter({
        adapterId: 'resources',
        fieldMap: _rule_migrations_field_maps.ruleMigrationResourcesFieldMap
      }),
      integrations: this.createIndexAdapter({
        adapterId: 'integrations',
        fieldMap: (0, _rule_migrations_field_maps.getIntegrationsFieldMap)({
          elserInferenceId
        })
      }),
      prebuiltrules: this.createIndexAdapter({
        adapterId: 'prebuiltrules',
        fieldMap: (0, _rule_migrations_field_maps.getPrebuiltRulesFieldMap)({
          elserInferenceId
        })
      })
    };
  }
  getAdapterIndexName(adapterId) {
    return `${INDEX_PATTERN}-${adapterId}`;
  }
  createIndexPatternAdapter({
    adapterId,
    fieldMap
  }) {
    const name = this.getAdapterIndexName(adapterId);
    const adapter = new _indexAdapter.IndexPatternAdapter(name, {
      kibanaVersion: this.kibanaVersion,
      totalFieldsLimit: TOTAL_FIELDS_LIMIT
    });
    adapter.setComponentTemplate({
      name,
      fieldMap
    });
    adapter.setIndexTemplate({
      name,
      componentTemplateRefs: [name]
    });
    return adapter;
  }
  createIndexAdapter({
    adapterId,
    fieldMap
  }) {
    const name = this.getAdapterIndexName(adapterId);
    const adapter = new _indexAdapter.IndexAdapter(name, {
      kibanaVersion: this.kibanaVersion,
      totalFieldsLimit: TOTAL_FIELDS_LIMIT
    });
    adapter.setComponentTemplate({
      name,
      fieldMap
    });
    adapter.setIndexTemplate({
      name,
      componentTemplateRefs: [name]
    });
    return adapter;
  }
  async runIndexMigrations(esClient) {
    const indexMigrator = new _index_migrators.RuleMigrationIndexMigrator(this.adapters, esClient, this.logger);
    await indexMigrator.run();
  }
  async install(params) {
    await Promise.all([this.adapters.rules.install({
      ...params,
      logger: this.logger
    }), this.adapters.resources.install({
      ...params,
      logger: this.logger
    }), this.adapters.integrations.install({
      ...params,
      logger: this.logger
    }), this.adapters.prebuiltrules.install({
      ...params,
      logger: this.logger
    }), this.adapters.migrations.install({
      ...params,
      logger: this.logger
    })]);
  }
  async setup(params) {
    await this.install(params);
    await this.runIndexMigrations(params.esClient);
  }
  createClient({
    spaceId,
    currentUser,
    esScopedClient,
    dependencies
  }) {
    const indexNameProviders = {
      rules: this.createIndexNameProvider(this.adapters.rules, spaceId),
      resources: this.createIndexNameProvider(this.adapters.resources, spaceId),
      integrations: async () => this.getAdapterIndexName('integrations'),
      prebuiltrules: async () => this.getAdapterIndexName('prebuiltrules'),
      migrations: this.createIndexNameProvider(this.adapters.migrations, spaceId)
    };
    return new _rule_migrations_data_client.RuleMigrationsDataClient(indexNameProviders, currentUser, esScopedClient, this.logger, spaceId, dependencies);
  }
  createIndexNameProvider(adapter, spaceId) {
    return async () => {
      await adapter.createIndex(spaceId); // This will resolve instantly when the index is already created
      return adapter.getIndexName(spaceId);
    };
  }
}
exports.RuleMigrationsDataService = RuleMigrationsDataService;