"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerSiemRuleMigrationsInstallRoute = void 0;
var _zodHelpers = require("@kbn/zod-helpers");
var _constants = require("../../../../../common/siem_migrations/constants");
var _rule_migration = require("../../../../../common/siem_migrations/model/api/rules/rule_migration.gen");
var _audit = require("./util/audit");
var _installation = require("./util/installation");
var _authz = require("./util/authz");
var _with_license = require("./util/with_license");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerSiemRuleMigrationsInstallRoute = (router, logger) => {
  router.versioned.post({
    path: _constants.SIEM_RULE_MIGRATION_INSTALL_PATH,
    access: 'internal',
    security: {
      authz: _authz.authz
    }
  }).addVersion({
    version: '1',
    validate: {
      request: {
        params: (0, _zodHelpers.buildRouteValidationWithZod)(_rule_migration.InstallMigrationRulesRequestParams),
        body: (0, _zodHelpers.buildRouteValidationWithZod)(_rule_migration.InstallMigrationRulesRequestBody)
      }
    }
  }, (0, _with_license.withLicense)(async (context, req, res) => {
    const {
      migration_id: migrationId
    } = req.params;
    const {
      ids,
      enabled = false
    } = req.body;
    const siemMigrationAuditLogger = new _audit.SiemMigrationAuditLogger(context.securitySolution);
    try {
      const ctx = await context.resolve(['core', 'alerting', 'securitySolution']);
      const securitySolutionContext = ctx.securitySolution;
      const savedObjectsClient = ctx.core.savedObjects.client;
      const rulesClient = await ctx.alerting.getRulesClient();
      await siemMigrationAuditLogger.logInstallRules({
        ids,
        migrationId
      });
      const installed = await (0, _installation.installTranslated)({
        migrationId,
        ids,
        enabled,
        securitySolutionContext,
        savedObjectsClient,
        rulesClient
      });
      return res.ok({
        body: {
          installed
        }
      });
    } catch (error) {
      logger.error(error);
      await siemMigrationAuditLogger.logInstallRules({
        ids,
        migrationId,
        error
      });
      return res.badRequest({
        body: error.message
      });
    }
  }));
};
exports.registerSiemRuleMigrationsInstallRoute = registerSiemRuleMigrationsInstallRoute;