"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerAssetCriticalityRoutes = void 0;
var _status = require("./status");
var _upsert = require("./upsert");
var _get = require("./get");
var _delete = require("./delete");
var _privileges = require("./privileges");
var _upload_csv = require("./upload_csv");
var _list = require("./list");
var _bulk_upload = require("./bulk_upload");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerAssetCriticalityRoutes = ({
  router,
  logger,
  config,
  getStartServices
}) => {
  // Internal routes
  (0, _privileges.assetCriticalityInternalPrivilegesRoute)(router, logger, getStartServices);
  (0, _status.assetCriticalityInternalStatusRoute)(router, logger);
  // Public routes
  (0, _upload_csv.assetCriticalityPublicCSVUploadRoute)(router, logger, config, getStartServices);
  (0, _bulk_upload.assetCriticalityPublicBulkUploadRoute)(router, logger, config);
  (0, _delete.assetCriticalityPublicDeleteRoute)(router, logger);
  (0, _get.assetCriticalityPublicGetRoute)(router, logger);
  (0, _list.assetCriticalityPublicListRoute)(router, logger);
  (0, _upsert.assetCriticalityPublicUpsertRoute)(router, logger);
};
exports.registerAssetCriticalityRoutes = registerAssetCriticalityRoutes;