"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetStatefulQueryBar = void 0;
var _react = require("react");
var _kibana = require("../../../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetStatefulQueryBar = () => {
  const {
    services: {
      navigation: {
        ui: {
          createTopNavWithCustomContext
        }
      },
      unifiedSearch,
      customDataService
    }
  } = (0, _kibana.useKibana)();
  const {
    ui: {
      getCustomSearchBar
    }
  } = unifiedSearch;
  const CustomSearchBar = (0, _react.useMemo)(() => getCustomSearchBar(customDataService), [customDataService, getCustomSearchBar]);
  const CustomStatefulTopNavKqlQueryBar = (0, _react.useMemo)(() => {
    const customUnifiedSearch = {
      ...unifiedSearch,
      ui: {
        ...unifiedSearch.ui,
        SearchBar: CustomSearchBar,
        AggregateQuerySearchBar: CustomSearchBar
      }
    };
    return createTopNavWithCustomContext(customUnifiedSearch);
  }, [CustomSearchBar, createTopNavWithCustomContext, unifiedSearch]);
  return {
    CustomStatefulTopNavKqlQueryBar
  };
};
exports.useGetStatefulQueryBar = useGetStatefulQueryBar;