"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MacrosFileUpload = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _translations = require("../../../../translations");
var _use_parse_file_input = require("../../../common/use_parse_file_input");
var _upload_file_button = require("../../../common/upload_file_button");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MacrosFileUpload = exports.MacrosFileUpload = /*#__PURE__*/_react.default.memo(({
  createResources,
  apiError,
  isLoading
}) => {
  const [macrosToUpload, setMacrosToUpload] = (0, _react.useState)([]);
  const filePickerRef = (0, _react.useRef)(null);
  const createMacros = (0, _react.useCallback)(() => {
    var _filePickerRef$curren;
    (_filePickerRef$curren = filePickerRef.current) === null || _filePickerRef$curren === void 0 ? void 0 : _filePickerRef$curren.removeFiles();
    createResources(macrosToUpload);
  }, [createResources, macrosToUpload]);
  const onFileParsed = (0, _react.useCallback)(content => {
    const macros = content.map(formatMacroRow);
    setMacrosToUpload(macros);
  }, []);
  const {
    parseFile,
    isParsing,
    error: fileError
  } = (0, _use_parse_file_input.useParseFileInput)(onFileParsed);
  const onFileChange = (0, _react.useCallback)(files => {
    setMacrosToUpload([]);
    parseFile(files);
  }, [parseFile]);
  const error = (0, _react.useMemo)(() => {
    if (apiError) {
      return apiError;
    }
    return fileError;
  }, [apiError, fileError]);
  const showLoader = isParsing || isLoading;
  const isButtonDisabled = showLoader || macrosToUpload.length === 0;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    helpText: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "danger",
      size: "xs"
    }, error),
    isInvalid: error != null,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
    id: "macrosFilePicker",
    ref: filePickerRef,
    fullWidth: true,
    initialPromptText: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      textAlign: "center"
    }, i18n.MACROS_DATA_INPUT_FILE_UPLOAD_PROMPT),
    accept: "application/json, application/x-ndjson",
    onChange: onFileChange,
    display: "large",
    "aria-label": "Upload macros file",
    isLoading: showLoader,
    disabled: showLoader,
    "data-test-subj": "macrosFilePicker",
    "data-loading": isParsing
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_upload_file_button.UploadFileButton, {
    onClick: createMacros,
    isLoading: showLoader,
    disabled: isButtonDisabled
  })))));
});
MacrosFileUpload.displayName = 'MacrosFileUpload';
const formatMacroRow = row => {
  if (!(0, _lodash.isPlainObject)(row.result)) {
    throw new Error(_translations.FILE_UPLOAD_ERROR.NOT_OBJECT);
  }
  const macroResource = {
    type: 'macro',
    name: row.result.title,
    content: row.result.definition
  };
  // resource document format validation delegated to API
  return macroResource;
};