"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.YOUR_CONVERSATIONS = exports.VIEW = exports.SUGGESTED_PROMPTS_CONTEXT_TOOLTIP = exports.REGENERATE = exports.RECOMMENDED_ACTIONS = exports.PROMPT_3_TITLE = exports.PROMPT_3_PROMPT = exports.PROMPT_3_DESCRIPTION = exports.PROMPT_2_TITLE = exports.PROMPT_2_PROMPT = exports.PROMPT_2_DESCRIPTION = exports.PROMPT_1_TITLE = exports.PROMPT_1_PROMPT = exports.PROMPT_1_DESCRIPTION = exports.NO_SUMMARY_AVAILABLE = exports.MISSING_CONNECTOR = exports.GENERATING = exports.GENERATE = exports.CONNECTOR_MISSING_MESSAGE_ADMIN = exports.CONNECTOR_MISSING_MESSAGE = exports.ALERT_FROM_FLYOUT = exports.ADVANCED_SETTINGS_LINK_TITLE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// START SUMMARY

const NO_SUMMARY_AVAILABLE = exports.NO_SUMMARY_AVAILABLE = _i18n.i18n.translate('xpack.securitySolution.alertSummary.noSummaryAvailable', {
  defaultMessage: 'No summary available'
});
const RECOMMENDED_ACTIONS = exports.RECOMMENDED_ACTIONS = _i18n.i18n.translate('xpack.securitySolution.alertSummary.recommendedActions', {
  defaultMessage: 'Recommended actions'
});
const GENERATING = exports.GENERATING = _i18n.i18n.translate('xpack.securitySolution.alertSummary.generating', {
  defaultMessage: 'Generating AI description and recommended actions.'
});
const GENERATE = exports.GENERATE = _i18n.i18n.translate('xpack.securitySolution.alertSummary.generate', {
  defaultMessage: 'Generate insights'
});
const REGENERATE = exports.REGENERATE = _i18n.i18n.translate('xpack.securitySolution.alertSummary.regenerate', {
  defaultMessage: 'Regenerate insights'
});
const MISSING_CONNECTOR = exports.MISSING_CONNECTOR = _i18n.i18n.translate('xpack.securitySolution.alertSummary.missingConnector', {
  defaultMessage: 'Missing connector'
});
const CONNECTOR_MISSING_MESSAGE = exports.CONNECTOR_MISSING_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.alertSummary.noConnectorMessage', {
  defaultMessage: 'Your default AI connector is invalid and may have been deleted.'
});
const CONNECTOR_MISSING_MESSAGE_ADMIN = exports.CONNECTOR_MISSING_MESSAGE_ADMIN = _i18n.i18n.translate('xpack.securitySolution.alertSummary.noConnectorMessageForAdmin', {
  defaultMessage: 'Your default AI connector is invalid and may have been deleted. You may update the default AI connector via'
});
const ADVANCED_SETTINGS_LINK_TITLE = exports.ADVANCED_SETTINGS_LINK_TITLE = _i18n.i18n.translate('xpack.securitySolution.alertSummary.advancedSettingsLinkTitle', {
  defaultMessage: 'Security Solution advanced settings'
});

// END SUMMARY

// START SUGGESTED PROMPTS

const ALERT_FROM_FLYOUT = exports.ALERT_FROM_FLYOUT = _i18n.i18n.translate('xpack.securitySolution.alertSummary.alertFromFlyout', {
  defaultMessage: 'Alert (from flyout)'
});
const PROMPT_1_TITLE = exports.PROMPT_1_TITLE = _i18n.i18n.translate('xpack.securitySolution.alertSummary.prompt1Title', {
  defaultMessage: 'Detailed Alert Analysis'
});
const PROMPT_1_DESCRIPTION = exports.PROMPT_1_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.alertSummary.prompt1Description', {
  defaultMessage: 'Dive deeper into what happened with this alert.'
});
const PROMPT_1_PROMPT = exports.PROMPT_1_PROMPT = _i18n.i18n.translate('xpack.securitySolution.alertSummary.prompt1Prompt', {
  defaultMessage: "Provide a thorough breakdown of this alert, including the attack technique, potential impact, and risk assessment. Explain the technical details in a way that's immediately actionable"
});
const PROMPT_2_TITLE = exports.PROMPT_2_TITLE = _i18n.i18n.translate('xpack.securitySolution.alertSummary.prompt2Title', {
  defaultMessage: 'Best practices for noisy alerts'
});
const PROMPT_2_DESCRIPTION = exports.PROMPT_2_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.alertSummary.prompt2Description', {
  defaultMessage: 'Find Related Threat Intelligence Articles from Elastic Security Labs.'
});
const PROMPT_2_PROMPT = exports.PROMPT_2_PROMPT = _i18n.i18n.translate('xpack.securitySolution.alertSummary.prompt2Prompt', {
  defaultMessage: 'Can you provide relevant Elastic Security Labs intelligence about the threat indicators or techniques in this alert? Include any known threat actors, campaigns, or similar attack patterns documented in ESL research.'
});
const PROMPT_3_TITLE = exports.PROMPT_3_TITLE = _i18n.i18n.translate('xpack.securitySolution.alertSummary.prompt3Title', {
  defaultMessage: 'Alert Remediation Strategy'
});
const PROMPT_3_DESCRIPTION = exports.PROMPT_3_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.alertSummary.prompt3Description', {
  defaultMessage: 'Generate Step-by-Step Remediation Plan.'
});
const PROMPT_3_PROMPT = exports.PROMPT_3_PROMPT = _i18n.i18n.translate('xpack.securitySolution.alertSummary.prompt3Prompt', {
  defaultMessage: 'Based on this alert, please outline a comprehensive remediation plan including immediate containment steps, investigation actions, and long-term mitigation strategies to prevent similar incidents.'
});
const SUGGESTED_PROMPTS_CONTEXT_TOOLTIP = exports.SUGGESTED_PROMPTS_CONTEXT_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.alertSummary.suggestedPromptsContextTooltip', {
  defaultMessage: 'Add this alert as context.'
});

// END SUGGESTED PROMPTS

// START AI ASSISTANT

const YOUR_CONVERSATIONS = exports.YOUR_CONVERSATIONS = _i18n.i18n.translate('xpack.securitySolution.aiAssistant.yourConversations', {
  defaultMessage: 'Your conversations'
});
const VIEW = exports.VIEW = _i18n.i18n.translate('xpack.securitySolution.aiAssistant.view', {
  defaultMessage: 'View'
});

// END AI ASSISTANT