"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EsqlRuleFieldEdit = EsqlRuleFieldEdit;
var _react = _interopRequireDefault(require("react"));
var _utility_types = require("../../../../../../../common/utility_types");
var _esql_query = require("./fields/esql_query");
var _alert_suppression = require("./fields/alert_suppression");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function EsqlRuleFieldEdit({
  fieldName
}) {
  switch (fieldName) {
    case 'esql_query':
      return /*#__PURE__*/_react.default.createElement(_esql_query.EsqlQueryEditForm, null);
    case 'alert_suppression':
      return /*#__PURE__*/_react.default.createElement(_alert_suppression.AlertSuppressionEditForm, null);
    default:
      return (0, _utility_types.assertUnreachable)(fieldName);
  }
}