"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.threatDefault = exports.stepDefineDefaultValue = exports.stepAboutDefaultValue = exports.ruleStepsOrder = exports.getStepScheduleDefaultValue = exports.defaultThreatMatchSchedule = exports.defaultSchedule = void 0;
var _threat_match_mapping_edit = require("../rule_creation/components/threat_match_mapping_edit");
var _alert_suppression_edit = require("../rule_creation/components/alert_suppression_edit");
var _threshold_alert_suppression_edit = require("../rule_creation/components/threshold_alert_suppression_edit");
var _query_bar_field = require("../rule_creation_ui/components/query_bar_field");
var _utils = require("../../../common/detection_engine/utils");
var _translations = require("../../timelines/components/timeline/translations");
var _constants = require("../../../common/constants");
var _constants2 = require("../../../common/detection_engine/constants");
var _types = require("./types");
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ruleStepsOrder = exports.ruleStepsOrder = [_types.RuleStep.defineRule, _types.RuleStep.aboutRule, _types.RuleStep.scheduleRule, _types.RuleStep.ruleActions];
const threatDefault = exports.threatDefault = [{
  framework: 'MITRE ATT&CK',
  tactic: {
    id: 'none',
    name: 'none',
    reference: 'none'
  },
  technique: []
}];
const stepDefineDefaultValue = exports.stepDefineDefaultValue = {
  anomalyThreshold: 50,
  index: [],
  indexPattern: {
    fields: [],
    title: ''
  },
  machineLearningJobId: [],
  ruleType: 'query',
  threatIndex: [],
  queryBar: _query_bar_field.DEFAULT_KQL_QUERY_FIELD_VALUE,
  threatQueryBar: {
    query: {
      query: _constants.DEFAULT_THREAT_MATCH_QUERY,
      language: 'kuery'
    },
    filters: [],
    saved_id: null
  },
  requiredFields: [],
  relatedIntegrations: [],
  threatMapping: _threat_match_mapping_edit.DEFAULT_THREAT_MAPPING_VALUE,
  threshold: {
    field: [],
    value: '200',
    cardinality: {
      field: [],
      value: ''
    }
  },
  timeline: {
    id: null,
    title: _translations.DEFAULT_TIMELINE_TITLE
  },
  eqlOptions: {},
  dataSourceType: _types.DataSourceType.IndexPatterns,
  newTermsFields: [],
  historyWindowSize: '7d',
  shouldLoadQueryDynamically: false,
  [_alert_suppression_edit.ALERT_SUPPRESSION_FIELDS_FIELD_NAME]: [],
  [_alert_suppression_edit.ALERT_SUPPRESSION_DURATION_TYPE_FIELD_NAME]: _types.AlertSuppressionDurationType.PerRuleExecution,
  [_alert_suppression_edit.ALERT_SUPPRESSION_DURATION_FIELD_NAME]: _alert_suppression_edit.ALERT_SUPPRESSION_DEFAULT_DURATION,
  [_alert_suppression_edit.ALERT_SUPPRESSION_MISSING_FIELDS_FIELD_NAME]: _constants2.DEFAULT_SUPPRESSION_MISSING_FIELDS_STRATEGY,
  [_threshold_alert_suppression_edit.THRESHOLD_ALERT_SUPPRESSION_ENABLED]: false
};
const stepAboutDefaultValue = exports.stepAboutDefaultValue = {
  author: [],
  name: '',
  description: '',
  isAssociatedToEndpointList: false,
  isBuildingBlock: false,
  severity: {
    value: 'low',
    mapping: (0, _helpers.fillEmptySeverityMappings)([]),
    isMappingChecked: false
  },
  riskScore: {
    value: 21,
    mapping: [],
    isMappingChecked: false
  },
  investigationFields: [],
  references: [''],
  falsePositives: [''],
  license: '',
  ruleNameOverride: '',
  tags: [],
  timestampOverride: '',
  threat: threatDefault,
  note: '',
  setup: '',
  threatIndicatorPath: undefined,
  timestampOverrideFallbackDisabled: undefined,
  maxSignals: _constants.DEFAULT_MAX_SIGNALS
};
const DEFAULT_INTERVAL = '5m';
const DEFAULT_FROM = '1m';
const THREAT_MATCH_INTERVAL = '1h';
const THREAT_MATCH_FROM = '5m';
const defaultSchedule = exports.defaultSchedule = {
  interval: DEFAULT_INTERVAL,
  from: DEFAULT_FROM
};
const defaultThreatMatchSchedule = exports.defaultThreatMatchSchedule = {
  interval: THREAT_MATCH_INTERVAL,
  from: THREAT_MATCH_FROM
};
const getStepScheduleDefaultValue = ruleType => {
  return {
    interval: (0, _utils.isThreatMatchRule)(ruleType) ? THREAT_MATCH_INTERVAL : DEFAULT_INTERVAL,
    from: (0, _utils.isThreatMatchRule)(ruleType) ? THREAT_MATCH_FROM : DEFAULT_FROM
  };
};
exports.getStepScheduleDefaultValue = getStepScheduleDefaultValue;