"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MisconfigurationFindingsDetailsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_misconfiguration_findings = require("@kbn/cloud-security-posture/src/hooks/use_misconfiguration_findings");
var _i18n = require("@kbn/i18n");
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _uiTheme = require("@kbn/ui-theme");
var _securitySolutionDistributionBar = require("@kbn/security-solution-distribution-bar");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _ui_metrics = require("@kbn/cloud-security-posture-common/utils/ui_metrics");
var _analytics = require("@kbn/analytics");
var _use_get_navigation_url_params = require("@kbn/cloud-security-posture/src/hooks/use_get_navigation_url_params");
var _deeplinksSecurity = require("@kbn/deeplinks-security");
var _use_has_misconfigurations = require("@kbn/cloud-security-posture/src/hooks/use_has_misconfigurations");
var _links = require("../../../common/components/links");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFindingsStats = (passedFindingsStats, failedFindingsStats, filterFunction, currentFilter) => {
  if (passedFindingsStats === 0 && failedFindingsStats === 0) return [];
  return [{
    key: _i18n.i18n.translate('xpack.securitySolution.flyout.right.insights.misconfigurations.passedFindingsText', {
      defaultMessage: 'Passed findings'
    }),
    count: passedFindingsStats,
    color: _uiTheme.euiThemeVars.euiColorSuccess,
    filter: () => {
      filterFunction(_cloudSecurityPostureCommon.MISCONFIGURATION_STATUS.PASSED);
    },
    isCurrentFilter: currentFilter === _cloudSecurityPostureCommon.MISCONFIGURATION_STATUS.PASSED,
    reset: event => {
      filterFunction('');
      event === null || event === void 0 ? void 0 : event.stopPropagation();
    }
  }, {
    key: _i18n.i18n.translate('xpack.securitySolution.flyout.right.insights.misconfigurations.failedFindingsText', {
      defaultMessage: 'Failed findings'
    }),
    count: failedFindingsStats,
    color: _uiTheme.euiThemeVars.euiColorVis9,
    filter: () => {
      filterFunction(_cloudSecurityPostureCommon.MISCONFIGURATION_STATUS.FAILED);
    },
    isCurrentFilter: currentFilter === _cloudSecurityPostureCommon.MISCONFIGURATION_STATUS.FAILED,
    reset: event => {
      filterFunction('');
      event === null || event === void 0 ? void 0 : event.stopPropagation();
    }
  }];
};

/**
 * Insights view displayed in the document details expandable flyout left section
 */
const MisconfigurationFindingsDetailsTable = exports.MisconfigurationFindingsDetailsTable = /*#__PURE__*/(0, _react.memo)(({
  field,
  value
}) => {
  (0, _react.useEffect)(() => {
    _ui_metrics.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.COUNT, _ui_metrics.ENTITY_FLYOUT_EXPAND_MISCONFIGURATION_VIEW_VISITS);
  }, []);
  const [currentFilter, setCurrentFilter] = (0, _react.useState)('');
  const [sortField, setSortField] = (0, _react.useState)(_use_misconfiguration_findings.MISCONFIGURATION.RESULT_EVALUATION);
  const [sortDirection, setSortDirection] = (0, _react.useState)('asc');
  const sortFieldDirection = {};
  sortFieldDirection[sortField] = sortDirection;
  const {
    data
  } = (0, _use_misconfiguration_findings.useMisconfigurationFindings)({
    query: (0, _cloudSecurityPostureCommon.buildMisconfigurationEntityFlyoutPreviewQuery)(field, value, currentFilter),
    sort: [sortFieldDirection],
    enabled: true,
    pageSize: 1
  });
  const {
    passedFindings,
    failedFindings
  } = (0, _use_has_misconfigurations.useHasMisconfigurations)(field, value);
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(10);
  const sorting = {
    sort: {
      field: sortField,
      direction: sortDirection
    }
  };
  const findingsPagination = findings => {
    let pageOfItems;
    if (!pageIndex && !pageSize) {
      pageOfItems = findings;
    } else {
      const startIndex = pageIndex * pageSize;
      pageOfItems = findings === null || findings === void 0 ? void 0 : findings.slice(startIndex, Math.min(startIndex + pageSize, findings === null || findings === void 0 ? void 0 : findings.length));
    }
    return {
      pageOfItems,
      totalItemCount: findings === null || findings === void 0 ? void 0 : findings.length
    };
  };
  const {
    pageOfItems,
    totalItemCount
  } = findingsPagination((data === null || data === void 0 ? void 0 : data.rows) || []);
  const pagination = {
    pageIndex,
    pageSize,
    totalItemCount,
    pageSizeOptions: [10, 25, 100]
  };
  const onTableChange = (0, _react.useCallback)(({
    page,
    sort
  }) => {
    if (page) {
      const {
        index,
        size
      } = page;
      setPageIndex(index);
      setPageSize(size);
    }
    if (sort) {
      const {
        field: fieldSort,
        direction
      } = sort;
      setSortField(fieldSort);
      setSortDirection(direction);
    }
  }, []);
  const getNavUrlParams = (0, _use_get_navigation_url_params.useGetNavigationUrlParams)();
  const getFindingsPageUrlFilteredByRuleAndResourceId = (ruleId, resourceId) => {
    return getNavUrlParams({
      'rule.id': ruleId,
      'resource.id': resourceId
    }, 'configurations');
  };
  const getFindingsPageUrl = (name, queryField) => {
    return getNavUrlParams({
      [queryField]: name
    }, 'configurations', ['rule.name']);
  };
  const linkWidth = 40;
  const resultWidth = 74;
  const misconfgurationStats = getFindingsStats(passedFindings, failedFindings, setCurrentFilter, currentFilter);
  const columns = [{
    field: 'rule',
    name: '',
    width: `${linkWidth}`,
    render: (rule, finding) => {
      var _finding$resource;
      return /*#__PURE__*/_react.default.createElement(_links.SecuritySolutionLinkAnchor, {
        deepLinkId: _deeplinksSecurity.SecurityPageName.cloudSecurityPostureFindings,
        path: `${getFindingsPageUrlFilteredByRuleAndResourceId(rule === null || rule === void 0 ? void 0 : rule.id, finding === null || finding === void 0 ? void 0 : (_finding$resource = finding.resource) === null || _finding$resource === void 0 ? void 0 : _finding$resource.id)}`,
        target: '_blank',
        external: false,
        onClick: () => {
          _ui_metrics.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.CLICK, _ui_metrics.NAV_TO_FINDINGS_BY_RULE_NAME_FRPOM_ENTITY_FLYOUT);
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: 'popout'
      }));
    }
  }, {
    field: _use_misconfiguration_findings.MISCONFIGURATION.RESULT_EVALUATION,
    render: result => /*#__PURE__*/_react.default.createElement(_cloudSecurityPosture.CspEvaluationBadge, {
      type: result
    }),
    name: _i18n.i18n.translate('xpack.securitySolution.flyout.left.insights.misconfigurations.table.resultColumnName', {
      defaultMessage: 'Result'
    }),
    width: `${resultWidth}px`,
    sortable: true
  }, {
    field: _use_misconfiguration_findings.MISCONFIGURATION.RULE_NAME,
    render: ruleName => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, ruleName),
    name: _i18n.i18n.translate('xpack.securitySolution.flyout.left.insights.misconfigurations.table.ruleColumnName', {
      defaultMessage: 'Rule'
    }),
    width: `calc(100% - ${linkWidth + resultWidth}px)`,
    sortable: true
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_links.SecuritySolutionLinkAnchor, {
    deepLinkId: _deeplinksSecurity.SecurityPageName.cloudSecurityPostureFindings,
    path: `${getFindingsPageUrl(value, field)}`,
    target: '_blank',
    external: false,
    onClick: () => {
      _ui_metrics.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.CLICK, _ui_metrics.NAV_TO_FINDINGS_BY_HOST_NAME_FRPOM_ENTITY_FLYOUT);
    }
  }, _i18n.i18n.translate('xpack.securitySolution.flyout.left.insights.misconfigurations.tableTitle', {
    defaultMessage: 'Misconfigurations '
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: 'popout'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_securitySolutionDistributionBar.DistributionBar, {
    stats: misconfgurationStats
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: pageOfItems || [],
    rowHeader: "result",
    columns: columns,
    pagination: pagination,
    onChange: onTableChange,
    "data-test-subj": 'securitySolutionFlyoutMisconfigurationFindingsTable',
    sorting: sorting
  })));
});
MisconfigurationFindingsDetailsTable.displayName = 'MisconfigurationFindingsDetailsTable';